package cn.wise.sc.acquisition.business.service.impl;

import cn.wise.sc.acquisition.business.constant.Rcode;
import cn.wise.sc.acquisition.business.entity.TAnnouncement;
import cn.wise.sc.acquisition.business.mapper.TAnnouncementMapper;
import cn.wise.sc.acquisition.business.model.query.TAnnouncementQuery;
import cn.wise.sc.acquisition.business.service.ITAnnouncementService;
import cn.wise.sc.acquisition.business.wrapper.page.Query;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * <p>
 *  服务实现类
 * </p>
 *
 * @author renchao
 * @since 2021-05-06
 */
@Service
@Transactional
@Slf4j
public class TAnnouncementServiceImpl extends ServiceImpl<TAnnouncementMapper, TAnnouncement> implements ITAnnouncementService {

    @Override
    public R getPage(TAnnouncementQuery tAnnouncementQuery, Query query) {
        log.info(JSON.toJSONString(tAnnouncementQuery));
        //参数校验
        //分页
        Page<TAnnouncement> page = new Page<>(query.getPageNum(), query.getPageSize());
        //条件封装
        QueryWrapper<TAnnouncement> queryWrapper = new QueryWrapper<>();
        //查询
        Page<TAnnouncement> tSampleListPage = baseMapper.selectPage(page, queryWrapper);
        return R.ok(tSampleListPage);
    }

    @Override
    public R getByUid(TAnnouncementQuery query) {
        log.info(JSON.toJSONString(query));
        //参数校验
        Rcode.NOT_PARAM.assertNotNull(query);
        Rcode.NOT_PARAM.assertNotEmpty(query.getUid());
        //查询
        TAnnouncement tAnnouncement = baseMapper.selectById(query.getUid());
        return R.ok(tAnnouncement);
    }
}
