package cn.wise.sc.acquisition.business.service.impl;

import cn.wise.im.common.http.R;
import cn.wise.sc.acquisition.business.constant.Rcode;
import cn.wise.sc.acquisition.business.entity.TEquipmentAccount;
import cn.wise.sc.acquisition.business.mapper.TEquipmentAccountMapper;
import cn.wise.sc.acquisition.business.model.PageQuery;
import cn.wise.sc.acquisition.business.model.query.PostQuery;
import cn.wise.sc.acquisition.business.model.query.TEquipmentAccountQuery;
import cn.wise.sc.acquisition.business.service.ITEquipmentAccountService;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 *  服务实现类
 * </p>
 *
 * @author ztw
 * @since 2021-04-23
 */
@Service
@Transactional
public class TEquipmentAccountServiceImpl extends ServiceImpl<TEquipmentAccountMapper, TEquipmentAccount> implements ITEquipmentAccountService {

	@Resource
	private TEquipmentAccountMapper equipmentAccountMapper;

	/**
	 * 分页列表
	 * @param pageQuery
	 * @param EquipmentName
	 * @return
	 */
	@Override
	public R<IPage<TEquipmentAccount>> getPage(PageQuery pageQuery, String EquipmentName) {
		QueryWrapper<TEquipmentAccount> qw = new QueryWrapper<>();
		if (StringUtils.isNotEmpty(EquipmentName)) {
			qw.like("EquipmentName", EquipmentName);
		}
		qw.orderByDesc("Ccrq");
		IPage<TEquipmentAccount> page = new Page<>(pageQuery.getPageNo(), pageQuery.getPageSize());
		page = equipmentAccountMapper.selectPage(page, qw);
		return R.ok(page);
	}

	/**
	 * 新增
	 * @param query
	 * @return
	 */
	@Override
	public R create(TEquipmentAccountQuery query) {
		Rcode.NOT_PARAM.assertNotNull(query);
		Rcode.NOT_PARAM.assertNotNull(query.getEquipmentName());
		TEquipmentAccount account = new TEquipmentAccount();
		BeanUtils.copyProperties(query, account);
		equipmentAccountMapper.insert(account);
		return R.ok();
	}

	/**
	 * 修改
	 * @param query
	 * @return
	 */
	@Override
	public R update(TEquipmentAccountQuery query) {
		Rcode.NOT_PARAM.assertNotNull(query);
		Rcode.NOT_PARAM.assertNotNull(query.getEquipmentID());
		Rcode.NOT_PARAM.assertNotNull(query.getEquipmentName());
		TEquipmentAccount account = equipmentAccountMapper.selectById(query.getEquipmentID());
		Rcode.NOT_FOUND.assertNotNull(account);
		BeanUtils.copyProperties(query, account);
		equipmentAccountMapper.updateById(account);
		return R.ok();
	}

	/**
	 * 详情
	 * @param EquipmentID
	 * @return
	 */
	@Override
	public R<TEquipmentAccount> getDetail(String EquipmentID) {
		Rcode.NOT_PARAM.assertNotNull(EquipmentID);
		TEquipmentAccount account = equipmentAccountMapper.selectById(EquipmentID);
		Rcode.NOT_FOUND.assertNotNull(account);
		return R.ok(account);
	}

	/**
	 * 列表
	 * @return
	 */
	@Override
	public R<List<TEquipmentAccount>> getList() {
		List<TEquipmentAccount> list = this.list();
		Rcode.NOT_FOUND.assertIsFalse(list!= null && list.size()>0);
		return R.ok(list);
	}

	/**
	 * 删除
	 * @param EquipmentID
	 * @return
	 */
	@Override
	public R<TEquipmentAccount> delete(String EquipmentID) {
		Rcode.NOT_PARAM.assertNotNull(EquipmentID);
		TEquipmentAccount account = equipmentAccountMapper.selectById(EquipmentID);
		Rcode.NOT_FOUND.assertNotNull(account);
		equipmentAccountMapper.deleteById(EquipmentID);
		return R.ok();
	}










}
