package cn.wise.sc.acquisition.business.service.impl;

import cn.wise.im.common.http.R;
import cn.wise.sc.acquisition.business.constant.Rcode;
import cn.wise.sc.acquisition.business.entity.TEquipmentAccount;
import cn.wise.sc.acquisition.business.entity.TEquipmentCheck;
import cn.wise.sc.acquisition.business.mapper.TEquipmentAccountMapper;
import cn.wise.sc.acquisition.business.mapper.TEquipmentCheckMapper;
import cn.wise.sc.acquisition.business.model.PageQuery;
import cn.wise.sc.acquisition.business.model.query.TEquipmentAccountQuery;
import cn.wise.sc.acquisition.business.model.query.TEquipmentCheckQuery;
import cn.wise.sc.acquisition.business.model.vo.TEquipmentCheckVo;
import cn.wise.sc.acquisition.business.model.vo.UserVo;
import cn.wise.sc.acquisition.business.service.ITEquipmentCheckService;
import cn.wise.sc.acquisition.business.wrapper.page.Query;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>
 *  服务实现类
 * </p>
 *
 * @author ztw
 * @since 2021-04-25
 */
@Service
@Transactional
public class TEquipmentCheckServiceImpl extends ServiceImpl<TEquipmentCheckMapper, TEquipmentCheck> implements ITEquipmentCheckService {

	@Resource
	private TEquipmentCheckMapper equipmentCheckMapper;
	@Resource
	private TEquipmentAccountMapper equipmentAccountMapper;


	/**
	 * 设备点检分页
	 * @param pageQuery
	 * @param EquipmentName
	 * @return
	 */
	@Override
	public R<IPage<TEquipmentCheckVo>> getPage(PageQuery pageQuery, String EquipmentName) {
		Map<String, Object> params = new HashMap<>();
		params.put("EquipmentName", EquipmentName);
		Page<TEquipmentCheckVo> page = new Page<>(pageQuery.getPageNo(), pageQuery.getPageSize());
		IPage<TEquipmentCheckVo> pages = equipmentCheckMapper.getPage(page, params);
		return R.ok(pages);
	}


	/**
	 * 设备点检详情
	 * @param EquipmentID
	 * @return
	 */
	@Override
	public R<TEquipmentCheck> getDetail(String EquipmentID) {
		Rcode.NOT_PARAM.assertNotNull(EquipmentID);
		TEquipmentAccount account = equipmentAccountMapper.selectById(EquipmentID);
		Rcode.NOT_FOUND.assertNotNull(account);
		QueryWrapper<TEquipmentCheck> checkWrapper = new QueryWrapper<>();
		checkWrapper.eq("EquipmentID", account.getEquipmentID());
		List<TEquipmentCheck> checkList = equipmentCheckMapper.selectList(checkWrapper);
		TEquipmentCheck check = null;
		if(checkList != null && checkList.size()>0){  //已经点检过的
			check = checkList.get(0);
		}else{
			check = new TEquipmentCheck();
			check.setEquipmentID(account.getEquipmentID()).setEquipmentName(account.getEquipmentName());
		}
		Rcode.NOT_FOUND.assertNotNull(check);
		return R.ok(check);
	}

	/**
	 * 保存设备点检结果
	 * @param query
	 * @return
	 */
	@Override
	public R checking(TEquipmentCheckQuery query) {
		Rcode.NOT_PARAM.assertNotNull(query);
		Rcode.NOT_PARAM.assertNotNull(query.getEquipmentID());
		Rcode.NOT_PARAM.assertNotNull(query.getEquipmentName());
		TEquipmentCheck check = new TEquipmentCheck();
		BeanUtils.copyProperties(query, check);
		//Uid=null新增，Uid！=null 修改
		if(StringUtils.isNoneBlank(check.getUid())){
			equipmentCheckMapper.updateById(check);
		}else{
			equipmentCheckMapper.insert(check);
		}
		return R.ok();
	}






















}
