package cn.wise.sc.acquisition.business.service.impl;

import cn.wise.im.common.http.R;
import cn.wise.im.common.http.ResponseEnum;
import cn.wise.sc.acquisition.business.constant.Rcode;
import cn.wise.sc.acquisition.business.entity.TEquipmentAccount;
import cn.wise.sc.acquisition.business.entity.TEquipmentCheck;
import cn.wise.sc.acquisition.business.entity.TEquipmentRun;
import cn.wise.sc.acquisition.business.mapper.TEquipmentAccountMapper;
import cn.wise.sc.acquisition.business.mapper.TEquipmentRunMapper;
import cn.wise.sc.acquisition.business.model.PageQuery;
import cn.wise.sc.acquisition.business.model.query.TEquipmentCheckQuery;
import cn.wise.sc.acquisition.business.model.query.TEquipmentRunQuery;
import cn.wise.sc.acquisition.business.model.vo.TEquipmentCheckVo;
import cn.wise.sc.acquisition.business.model.vo.TEquipmentRunVo;
import cn.wise.sc.acquisition.business.service.ITEquipmentRunService;
import cn.wise.sc.acquisition.business.service.ITSysDictService;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author ztw
 * @since 2021-04-25
 */
@Service
@Transactional
public class TEquipmentRunServiceImpl extends ServiceImpl<TEquipmentRunMapper, TEquipmentRun> implements ITEquipmentRunService {

    @Resource
    private TEquipmentRunMapper equipmentRunMapper;
    @Resource
    private TEquipmentAccountMapper equipmentAccountMapper;

    @Autowired
    private ITSysDictService itSysDictService;

    /**
     * 设备运行分页
     *
     * @param pageQuery
     * @param EquipmentName
     * @return
     */
    @Override
    public R<IPage<TEquipmentRunVo>> getPage(PageQuery pageQuery, String EquipmentName) {
        Map<String, Object> params = new HashMap<>();
        params.put("EquipmentName", EquipmentName);
        Page<TEquipmentRunVo> page = new Page<>(pageQuery.getPageNo(), pageQuery.getPageSize());
        IPage<TEquipmentRunVo> pages = equipmentRunMapper.getPage(page, params);
        return R.ok(pages);
    }

    /**
     * 设备运行详情
     *
     * @param EquipmentID
     * @return
     */
    @Override
    public R<TEquipmentRun> getDetail(String EquipmentID) {
        Rcode.NOT_PARAM.assertNotNull(EquipmentID);
        TEquipmentAccount account = equipmentAccountMapper.selectById(EquipmentID);
        Rcode.NOT_FOUND.assertNotNull(account);
        QueryWrapper<TEquipmentRun> checkWrapper = new QueryWrapper<>();
        checkWrapper.eq("EquipmentID", account.getEquipmentID());
        List<TEquipmentRun> runList = equipmentRunMapper.selectList(checkWrapper);
        TEquipmentRun run = null;
        if (runList != null && runList.size() > 0) {  //已经点检过的
            run = runList.get(0);
        } else {
            run = new TEquipmentRun();
            run.setEquipmentID(account.getEquipmentID()).setEquipmentName(account.getEquipmentName());
        }
        Rcode.NOT_FOUND.assertNotNull(run);
        return R.ok(run);
    }

    /**
     * 保存设备运行结果
     *
     * @param query
     * @return
     */
    @Override
    public R running(TEquipmentRunQuery query) {
        Rcode.NOT_PARAM.assertNotNull(query);
        Rcode.NOT_PARAM.assertNotNull(query.getEquipmentID());
        Rcode.NOT_PARAM.assertNotNull(query.getEquipmentName());
        if (StringUtils.isNotBlank(query.getTag())) {
            return R.fail(ResponseEnum.FAIL, "设备运行中，tag不能修改或者添加");
        }
        TEquipmentRun run = new TEquipmentRun();
        BeanUtils.copyProperties(query, run);
        //Uid=null新增，Uid！=null 修改
        if (StringUtils.isNoneBlank(run.getUid())) {
            equipmentRunMapper.updateById(run);
        } else {
            //设置tag
            com.baomidou.mybatisplus.extension.api.R r = itSysDictService.getTagDate(null);
            if (r.getCode() != 0) {
                return R.fail(ResponseEnum.FAIL, r.getMsg());
            }
            run.setTag((String) r.getData());
            equipmentRunMapper.insert(run);
        }
        return R.ok();
    }


}
