package cn.wise.sc.acquisition.business.service.impl;

import cn.wise.im.common.http.R;
import cn.wise.sc.acquisition.business.constant.Rcode;
import cn.wise.sc.acquisition.business.entity.TEquipmentAccount;
import cn.wise.sc.acquisition.business.entity.TEquipmentCheck;
import cn.wise.sc.acquisition.business.entity.TEquipmentTrouble;
import cn.wise.sc.acquisition.business.mapper.TEquipmentAccountMapper;
import cn.wise.sc.acquisition.business.mapper.TEquipmentTroubleMapper;
import cn.wise.sc.acquisition.business.model.PageQuery;
import cn.wise.sc.acquisition.business.model.query.TEquipmentCheckQuery;
import cn.wise.sc.acquisition.business.model.query.TEquipmentTroubleQuery;
import cn.wise.sc.acquisition.business.model.vo.TEquipmentCheckVo;
import cn.wise.sc.acquisition.business.model.vo.TEquipmentTroubleVo;
import cn.wise.sc.acquisition.business.service.ITEquipmentTroubleService;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>
 *  服务实现类
 * </p>
 *
 * @author ztw
 * @since 2021-04-25
 */
@Service
public class TEquipmentTroubleServiceImpl extends ServiceImpl<TEquipmentTroubleMapper, TEquipmentTrouble> implements ITEquipmentTroubleService {

	@Resource
	private TEquipmentTroubleMapper equipmentTroubleMapper;
	@Resource
	private TEquipmentAccountMapper equipmentAccountMapper;



	/**
	 * 设备隐患分页
	 * @param pageQuery
	 * @param EquipmentName
	 * @return
	 */
	@Override
	public R<IPage<TEquipmentTroubleVo>> getPage(PageQuery pageQuery, String EquipmentName) {
		Map<String, Object> params = new HashMap<>();
		params.put("EquipmentName", EquipmentName);
		Page<TEquipmentTroubleVo> page = new Page<>(pageQuery.getPageNo(), pageQuery.getPageSize());
		IPage<TEquipmentTroubleVo> pages = equipmentTroubleMapper.getPage(page, params);
		return R.ok(pages);
	}


	/**
	 * 设备隐患详情
	 * @param EquipmentID
	 * @return
	 */
	@Override
	public R<TEquipmentTrouble> getDetail(String EquipmentID) {
		Rcode.NOT_PARAM.assertNotNull(EquipmentID);
		TEquipmentAccount account = equipmentAccountMapper.selectById(EquipmentID);
		Rcode.NOT_FOUND.assertNotNull(account);
		QueryWrapper<TEquipmentTrouble> checkWrapper = new QueryWrapper<>();
		checkWrapper.eq("EquipmentID", account.getEquipmentID());
		List<TEquipmentTrouble> checkList = equipmentTroubleMapper.selectList(checkWrapper);
		TEquipmentTrouble trouble = null;
		if(checkList != null && checkList.size()>0){  //已经隐患过的
			trouble = checkList.get(0);
		}else{
			trouble = new TEquipmentTrouble();
			trouble.setEquipmentID(account.getEquipmentID()).setEquipmentName(account.getEquipmentName());
		}
		Rcode.NOT_FOUND.assertNotNull(trouble);
		return R.ok(trouble);
	}

	/**
	 * 保存设备隐患结果
	 * @param query
	 * @return
	 */
	@Override
	public R trouble(TEquipmentTroubleQuery query) {
		Rcode.NOT_PARAM.assertNotNull(query);
		Rcode.NOT_PARAM.assertNotNull(query.getEquipmentID());
		Rcode.NOT_PARAM.assertNotNull(query.getEquipmentName());
		TEquipmentTrouble trouble = new TEquipmentTrouble();
		BeanUtils.copyProperties(query, trouble);
		//Uid=null新增，Uid！=null 修改
		if(StringUtils.isNoneBlank(query.getUid())){
			equipmentTroubleMapper.updateById(trouble);
		}else{
			equipmentTroubleMapper.insert(trouble);
		}
		return R.ok();
	}









}
