package cn.wise.sc.acquisition.business.service.impl;

import cn.wise.im.common.http.R;
import cn.wise.im.common.http.ResponseEnum;
import cn.wise.sc.acquisition.business.constant.Rcode;
import cn.wise.sc.acquisition.business.entity.TMaterialOut;
import cn.wise.sc.acquisition.business.enumation.ProjectEnum;
import cn.wise.sc.acquisition.business.mapper.TMaterialOutMapper;
import cn.wise.sc.acquisition.business.model.PageQuery;
import cn.wise.sc.acquisition.business.model.query.TMaterialOutQuery;
import cn.wise.sc.acquisition.business.service.ITMaterialOutService;
import cn.wise.sc.acquisition.business.service.ITSysDictService;
import cn.wise.sc.acquisition.business.util.DateUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.Arrays;
import java.util.List;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author renchao
 * @since 2021-04-27
 */
@Service
@Transactional
@Slf4j
public class TMaterialOutServiceImpl extends ServiceImpl<TMaterialOutMapper, TMaterialOut> implements ITMaterialOutService {

    @Resource
    private TMaterialOutMapper materialOutMapper;

    @Autowired
    private ITSysDictService itSysDictService;

    /**
     * 分页列表
     *
     * @param pageQuery
     * @return
     */
    @Override
    public R<IPage<TMaterialOut>> getPage(PageQuery pageQuery) {
        QueryWrapper<TMaterialOut> qw = new QueryWrapper<>();
        qw.orderByDesc("Tag");
        IPage<TMaterialOut> page = new Page<>(pageQuery.getPageNo(), pageQuery.getPageSize());
        page = materialOutMapper.selectPage(page, qw);
        return R.ok(page);
    }

    /**
     * 领用出库
     *
     * @param query
     * @return
     */
    @Override
    public R delivery(TMaterialOutQuery query) {
        Rcode.NOT_PARAM.assertNotNull(query);
        Rcode.NOT_PARAM.assertNotNull(query.getEquipmentID());
        Rcode.NOT_PARAM.assertNotNull(query.getEquipmentName());
        if (StringUtils.isNotBlank(query.getTag())) {
            return R.fail(ResponseEnum.FAIL, "出库单中->tag标注日期不能添加");
        }
        TMaterialOut out = new TMaterialOut();
        BeanUtils.copyProperties(query, out);
        //设置标注日期
        com.baomidou.mybatisplus.extension.api.R r = itSysDictService.getTagDate(null);
        if (r.getCode() != 0) {
            return R.fail(ResponseEnum.FAIL, r.getMsg());
        }
        out.setTag((String) r.getData());
        materialOutMapper.insert(out);
        return R.ok();
    }

    /**
     * 修改领用出库
     *
     * @param query
     * @return
     */
    @Override
    public R update(TMaterialOutQuery query) {
        Rcode.NOT_PARAM.assertNotNull(query);
        Rcode.NOT_PARAM.assertNotNull(query.getEquipmentID());
        Rcode.NOT_PARAM.assertNotNull(query.getEquipmentName());
        if (StringUtils.isNotBlank(query.getTag())) {
            return R.fail(ResponseEnum.FAIL, "出库单中->tag标注日期不能修改");
        }
        TMaterialOut out = materialOutMapper.selectById(query.getUid());
        Rcode.NOT_FOUND.assertNotNull(out);
        BeanUtils.copyProperties(query, out);
        materialOutMapper.updateById(out);
        return R.ok();
    }

    /**
     * 领用出库详情
     *
     * @param Uid
     * @return
     */
    @Override
    public R<TMaterialOut> getDetail(String Uid) {
        Rcode.NOT_PARAM.assertNotNull(Uid);
        TMaterialOut out = materialOutMapper.selectById(Uid);
        Rcode.NOT_FOUND.assertNotNull(out);
        return R.ok(out);
    }


    /**
     * 物资消耗列表查询 分页列表
     *
     * @param tMaterialOutQuery
     * @return
     */
    @Override
    public R<IPage<TMaterialOut>> getConsumePage(TMaterialOutQuery tMaterialOutQuery, PageQuery query) {
        log.info(JSON.toJSONString(tMaterialOutQuery));
        //参数校验
        //分页
        Page<TMaterialOut> page = new Page<>(query.getPageNo(), query.getPageSize());
        //条件封装
        QueryWrapper<TMaterialOut> queryWrapper = new QueryWrapper<>();
        //如果设计时间不为空  条件查询
        if (tMaterialOutQuery.getConsumeDate() != null) {
            //前端传来的时间可能为2021-04-05 17:37:33.000, 需要查询 2021-04-05 00:00:00 到 2021-04-05 23:59:59 的数据 故作处理
            queryWrapper
                    .ge(ProjectEnum.TMaterialOut.CONSUME_DATE.getLabel(), DateUtil.getBeginTimeStr(tMaterialOutQuery.getConsumeDate()))
                    .le(ProjectEnum.TMaterialOut.CONSUME_DATE.getLabel(), DateUtil.getEndTimeStr(tMaterialOutQuery.getConsumeDate()));
        }
        queryWrapper.eq(StringUtils.isNotBlank(tMaterialOutQuery.getProcessesName()),
                ProjectEnum.TMaterialOut.PROCESSES_NAME.getLabel(),
                tMaterialOutQuery.getProcessesName());
        //查询
        Page<TMaterialOut> tMaterialOutPage = baseMapper.selectPage(page, queryWrapper);
        return R.ok(tMaterialOutPage);
    }


    /**
     * 获取工序名称字典
     *
     * @return
     */
    @Override
    public R getProcessesType() {
        List<String> processes = Arrays.asList(
                ProjectEnum.ProcessesType.T_PROCESSES_DRILLING.getLabel(),
                ProjectEnum.ProcessesType.T_PROCESSES_BLAST.getLabel(),
                ProjectEnum.ProcessesType.T_PROCESSES_DIGGING.getLabel(),
                ProjectEnum.ProcessesType.T_PROCESSES_TRUCK.getLabel(),
                ProjectEnum.ProcessesType.T_PROCESSES_CRUSHER.getLabel(),
                ProjectEnum.ProcessesType.T_PROCESSES_AUXILIARY.getLabel()
        );
        return R.ok(processes);
    }
}
