package cn.wise.sc.acquisition.business.service.impl;

import cn.wise.sc.acquisition.business.constant.Rcode;
import cn.wise.sc.acquisition.business.entity.TMineStope;
import cn.wise.sc.acquisition.business.enumation.ProjectEnum;
import cn.wise.sc.acquisition.business.mapper.TMineStopeMapper;
import cn.wise.sc.acquisition.business.model.query.TMineStopeQuery;
import cn.wise.sc.acquisition.business.service.ITMineStopeService;
import cn.wise.sc.acquisition.business.wrapper.page.Query;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author renchao
 * @since 2021-04-30
 */
@Service
@Slf4j
public class TMineStopeServiceImpl extends ServiceImpl<TMineStopeMapper, TMineStope> implements ITMineStopeService {


    @Override
    public R getPage(TMineStopeQuery tMineStopeQuery, Query query) {
        log.info(JSON.toJSONString(tMineStopeQuery));
        //参数校验
        //分页
        Page<TMineStope> page = new Page<>(query.getPageNum(), query.getPageSize());
        //条件封装
        QueryWrapper<TMineStope> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq(ProjectEnum.TMineStope.IS_USING.getLabel(), ProjectEnum.TMineStope.USING.getLabel());
        //查询分页数据
        Page<TMineStope> data = baseMapper.selectPage(page, queryWrapper);
        return R.ok(data);
    }

    @Override
    public R updateByQuery(TMineStopeQuery query) {
        log.info(JSON.toJSONString(query));
        //参数校验
        Rcode.NOT_PARAM.assertNotNull(query);
        Rcode.NOT_PARAM.assertNotEmpty(query.getStopeName());
        Rcode.NOT_PARAM.assertNotEmpty(query.getStepName());
        Rcode.NOT_PARAM.assertNotEmpty(query.getBlastAreaName());
        //封装
        QueryWrapper<TMineStope> queryWrapper = new QueryWrapper<>();
        queryWrapper
                .eq(ProjectEnum.TProcessesBlastdesignVolume.STOPE_NAME.getLabel(), query.getStopeName())
                .eq(ProjectEnum.TProcessesBlastdesignVolume.STEP_NAME.getLabel(), query.getStepName())
                .eq(ProjectEnum.TProcessesBlastdesignVolume.BLAST_AREA_NAME.getLabel(), query.getBlastAreaName());
        //查询并且返回
        return R.ok(baseMapper.selectOne(queryWrapper));
    }

    @Override
    public R getByQuery(TMineStopeQuery query) {
        log.info(JSON.toJSONString(query));
        //参数校验
        Rcode.NOT_PARAM.assertNotNull(query);
        Rcode.NOT_PARAM.assertNotEmpty(query.getStopeName());
        Rcode.NOT_PARAM.assertNotEmpty(query.getStepName());
        Rcode.NOT_PARAM.assertNotEmpty(query.getBlastAreaName());
        //封装
        QueryWrapper<TMineStope> queryWrapper = new QueryWrapper<>();
        queryWrapper
                .eq(ProjectEnum.TMineStope.IS_USING.getLabel(), ProjectEnum.TMineStope.USING.getLabel())
                .eq(ProjectEnum.TMineStope.STOPE_NAME.getLabel(), query.getStopeName())
                .eq(ProjectEnum.TMineStope.STEP_NAME.getLabel(), query.getStepName())
                .eq(ProjectEnum.TMineStope.BLAST_AREA_NAME.getLabel(), query.getBlastAreaName());
        //查询并且返回
        return R.ok(baseMapper.selectOne(queryWrapper));
    }

}
