package cn.wise.sc.acquisition.business.service.impl;

import cn.wise.sc.acquisition.business.constant.Rcode;
import cn.wise.sc.acquisition.business.entity.TMineWorkemployees;
import cn.wise.sc.acquisition.business.enumation.ProjectEnum;
import cn.wise.sc.acquisition.business.mapper.TMineWorkemployeesMapper;
import cn.wise.sc.acquisition.business.model.query.TMineWorkemployeesQuery;
import cn.wise.sc.acquisition.business.service.ITMineWorkemployeesService;
import cn.wise.sc.acquisition.business.service.ITSysDictService;
import cn.wise.sc.acquisition.business.util.BeanUtilsNewCopy;
import cn.wise.sc.acquisition.business.util.DateUtil;
import cn.wise.sc.acquisition.business.wrapper.page.Query;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author renchao
 * @since 2021-05-17
 */
@Service
@Slf4j
public class TMineWorkemployeesServiceImpl extends ServiceImpl<TMineWorkemployeesMapper, TMineWorkemployees> implements ITMineWorkemployeesService {

    @Autowired
    private ITSysDictService itSysDictService;

    @Override
    public R getPage(TMineWorkemployeesQuery tMineWorkemployeesQuery, Query query) {
        log.info(JSON.toJSONString(tMineWorkemployeesQuery));
        //参数校验
        //分页
        Page<TMineWorkemployees> page = new Page<>(query.getPageNum(), query.getPageSize());
        //条件封装
        QueryWrapper<TMineWorkemployees> queryWrapper = new QueryWrapper<>();
        //如果上班日期不为空 因为涉及到表连接，需要创建字段别名
        if (tMineWorkemployeesQuery.getGzsj() != null) {
            //前端传来的时间可能为2021-04-05 17:37:33.000, 需要查询 2021-04-05 00:00:00 到 2021-04-05 23:59:59 的数据 故作处理
            queryWrapper
                    .ge(ProjectEnum.TMineWorkemployees.GZSJ.getLabel(), DateUtil.getBeginTimeStr(tMineWorkemployeesQuery.getGzsj()))
                    .le(ProjectEnum.TMineWorkemployees.GZSJ.getLabel(), DateUtil.getEndTimeStr(tMineWorkemployeesQuery.getGzsj()));
        }
        //查询分页数据
        Page<TMineWorkemployees> data = baseMapper.selectPage(page, queryWrapper);
        return R.ok(data);
    }


    @Override
    public R getByQuery(TMineWorkemployeesQuery query) {
        log.info(JSON.toJSONString(query));
        //参数校验
        Rcode.NOT_PARAM.assertNotNull(query);
        //封装
        QueryWrapper<TMineWorkemployees> queryWrapper = new QueryWrapper<>();
        if (query.getGzsj() != null) {
            queryWrapper
                    .ge(ProjectEnum.TMineWorkemployees.GZSJ.getLabel(), DateUtil.getBeginTime(query.getGzsj()))
                    .le(ProjectEnum.TMineWorkemployees.GZSJ.getLabel(), DateUtil.getEndTime(query.getGzsj()));
        }
        //查询并且返回
        return R.ok(baseMapper.selectOne(queryWrapper));
    }

    @Override
    public R insertTMineWorkemployees(TMineWorkemployeesQuery query) {
        log.info(JSON.toJSONString(query));
        //参数校验
        Rcode.NOT_PARAM.assertNotNull(query);
        //uid自动生成 不能手动设置
        if (query.getUid() != null) {
            return R.failed("员工上班统计中->uid自动生成 不能手动设置");
        }
        //tag不能添加
        if (StringUtils.isNotBlank(query.getTag())) {
            return R.failed("员工上班统计中->tag自动生成不能添加");
        }
        //上班总人数不能修改
        if (query.getZrs() != null) {
            return R.failed("员工上班统计中->上班总人数自动计算");
        }
        //上班日期不能重复
        if (query.getGzsj() != null) {
            R r1 = getByQuery(query);
            if (r1.getData() != null) {
                return R.failed("员工上班统计中->上班日期已存在");
            }
        }
        //封装
        TMineWorkemployees tMineWorkemployees = new TMineWorkemployees();
        BeanUtilsNewCopy.copyPropertiesIgnoreNull(query, tMineWorkemployees);
        //设置tag
        R r1 = itSysDictService.getTagDate(null);
        if (r1.getCode() != 0) {
            return R.failed(r1.getMsg());
        }
        tMineWorkemployees.setTag((String) r1.getData());
        //计算上班总人数
        tMineWorkemployees.setZrs(calculateZrs(tMineWorkemployees));
        //保存
        int insert = baseMapper.insert(tMineWorkemployees);
        if (insert > 0) {
            return R.ok("员工上班统计中->添加成功");
        } else {
            log.error("员工上班统计中->添加失败:{}", tMineWorkemployees);
            return R.failed("员工上班统计中->添加失败");
        }
    }

    @Override
    public R updateByUid(TMineWorkemployeesQuery query) {
        log.info(JSON.toJSONString(query));
        //参数校验
        Rcode.NOT_PARAM.assertNotNull(query);
        Rcode.NOT_PARAM.assertNotNull(query.getUid());
        //判断日期是否存在
        if (query.getGzsj() != null) {
            R r1 = getByQuery(query);
            //如果日期存在，需要排除是否是当前数据
            if (r1.getData() != null) {
                TMineWorkemployees tMineWorkemployees = (TMineWorkemployees) r1.getData();
                if (!query.getUid().equals(tMineWorkemployees.getUid())){
                    return R.failed("员工上班统计中->上班日期已存在，不能修改");
                }
            }
        }
        //tag不能添加
        if (StringUtils.isNotBlank(query.getTag())) {
            return R.failed("员工上班统计中->tag自动生成不能修改");
        }
        //上班总人数不能修改
        if (query.getZrs() != null) {
            return R.failed("员工上班统计中->上班总人数自动计算不能修改");
        }
        //封装
        TMineWorkemployees tMineWorkemployees = new TMineWorkemployees();
        BeanUtilsNewCopy.copyPropertiesIgnoreNull(query, tMineWorkemployees);
        //重新计算上班总人数
        tMineWorkemployees.setZrs(calculateZrs(tMineWorkemployees));
        QueryWrapper<TMineWorkemployees> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq(ProjectEnum.TProcessesBlastdesignHole.UID.getLabel(), query.getUid());
        //修改
        int update = baseMapper.update(tMineWorkemployees, queryWrapper);
        if (update > 0) {
            return R.ok("员工上班统计中->修改成功");
        } else {
            log.error("员工上班统计中->修改失败：{}", tMineWorkemployees);
            return R.failed("员工上班统计中->修改失败");
        }
    }

    /**
     * 计算上班总人数 私有方法
     *
     * @param tMineWorkemployees
     * @return
     */
    private int calculateZrs(TMineWorkemployees tMineWorkemployees) {
        int zrs = 0;
        if (tMineWorkemployees != null) {
            if (tMineWorkemployees.getBprs() != null) zrs += tMineWorkemployees.getBprs();
            if (tMineWorkemployees.getCkrs() != null) zrs += tMineWorkemployees.getCkrs();
            if (tMineWorkemployees.getFzrs() != null) zrs += tMineWorkemployees.getFzrs();
            if (tMineWorkemployees.getPsrs() != null) zrs += tMineWorkemployees.getPsrs();
            if (tMineWorkemployees.getZcrs() != null) zrs += tMineWorkemployees.getZcrs();
            if (tMineWorkemployees.getYsrs() != null) zrs += tMineWorkemployees.getYsrs();
            return zrs;
        } else {
            log.error("员工上班统计中->计算上班总人数时 对象为空");
            return zrs;
        }
    }
}
