package cn.wise.sc.acquisition.business.service.impl;

import cn.wise.sc.acquisition.business.constant.Rcode;
import cn.wise.sc.acquisition.business.entity.TProcessesAuxiliary;
import cn.wise.sc.acquisition.business.enumation.ProjectEnum;
import cn.wise.sc.acquisition.business.mapper.TProcessesAuxiliaryMapper;
import cn.wise.sc.acquisition.business.model.query.TProcessesAuxiliaryQuery;
import cn.wise.sc.acquisition.business.service.ITProcessesAuxiliaryService;
import cn.wise.sc.acquisition.business.service.ITSysDictService;
import cn.wise.sc.acquisition.business.wrapper.page.Query;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author renchao
 * @since 2021-04-30
 */
@Service
@Slf4j
public class TProcessesAuxiliaryServiceImpl extends ServiceImpl<TProcessesAuxiliaryMapper, TProcessesAuxiliary> implements ITProcessesAuxiliaryService {

    @Autowired
    private ITSysDictService itSysDictService;

    @Override
    public R getPage(TProcessesAuxiliaryQuery tProcessesAuxiliaryQuery, Query query) {
        log.info(JSON.toJSONString(tProcessesAuxiliaryQuery));
        //参数校验
        //分页
        Page<TProcessesAuxiliary> page = new Page<>(query.getPageNum(), query.getPageSize());
        //条件封装
        QueryWrapper<TProcessesAuxiliary> queryWrapper = new QueryWrapper<>();
        queryWrapper.select(
                ProjectEnum.TProcessesAuxiliary.UID.getLabel(),
                ProjectEnum.TProcessesAuxiliary.EQUIPMENT_ID.getLabel(),
                ProjectEnum.TProcessesAuxiliary.EQUIPMENT_NAME.getLabel(),
                ProjectEnum.TProcessesAuxiliary.LJYL.getLabel(),
                ProjectEnum.TProcessesAuxiliary.ZJ.getLabel(),
                ProjectEnum.TProcessesAuxiliary.TAG.getLabel(),
                ProjectEnum.TProcessesAuxiliary.DYLJCL.getLabel(),
                ProjectEnum.TProcessesAuxiliary.DRIVER.getLabel(),
                ProjectEnum.TProcessesAuxiliary.DH.getLabel()
        );
        queryWrapper.eq(StringUtils.isNotBlank(tProcessesAuxiliaryQuery.getEquipmentID()),
                ProjectEnum.TProcessesAuxiliary.EQUIPMENT_ID.getLabel(), tProcessesAuxiliaryQuery.getEquipmentID());
        //查询
        Page<TProcessesAuxiliary> tSampleListPage = baseMapper.selectPage(page, queryWrapper);
        return R.ok(tSampleListPage);
    }

    @Override
    public R updateByUid(TProcessesAuxiliaryQuery query) {

        log.info(JSON.toJSONString(query));
        //参数校验
        Rcode.NOT_PARAM.assertNotNull(query);
        Rcode.NOT_PARAM.assertNotEmpty(query.getUid());
        //判断数据是否存在
        TProcessesAuxiliary temp = baseMapper.selectById(query.getUid());
        if (temp == null) {
            return R.failed("辅助工序中->数据不存在，uid：" + query.getUid());
        }
        //tag不能修改
        if (StringUtils.isNotBlank(query.getTag())) {
            return R.failed("辅助工序中->tag为自动生成字段，不能修改");
        }
        //条件封装
        TProcessesAuxiliary tSampleList = new TProcessesAuxiliary();
        BeanUtils.copyProperties(query, tSampleList);

        QueryWrapper<TProcessesAuxiliary> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq(ProjectEnum.TProcessesAuxiliary.UID.getLabel(), query.getUid());
        //修改
        int update = baseMapper.update(tSampleList, queryWrapper);
        if (update > 0) {
            return R.ok("辅助工序中->修改成功");
        } else {
            log.error("辅助工序中->修改失败:{}", JSON.toJSONString(tSampleList));
            return R.failed("辅助工序中->修改失败");
        }

    }

    @Override
    public R insertTProcessesAuxiliary(TProcessesAuxiliaryQuery query) {
        log.info(JSON.toJSONString(query));
        //参数校验
        Rcode.NOT_PARAM.assertNotNull(query);
        Rcode.NOT_PARAM.assertNotNull(query.getLjyl());
        Rcode.NOT_PARAM.assertNotNull(query.getZj());
        Rcode.NOT_PARAM.assertNotNull(query.getDyljcl());
        //uid自动生成 不能手动设置
        if (query.getUid() != null) {
            return R.failed("辅助工序中->uid自动生成 不能手动设置");
        }
        //tag不能修改
        if (StringUtils.isNotBlank(query.getTag())) {
            return R.failed("辅助工序中->tag为自动生成字段，不能添加");
        }
        //单耗为自动计算
        if (query.getDh() != null) {
            return R.failed("辅助工序中->dh为自动计算字段，不能添加");
        }
        //当月累计油量不为0时，当月累计产量不能为0
        if (query.getLjyl() != 0 && query.getDyljcl() == 0) {
            return R.failed("辅助工序中->当月累计油量Ljyl 不为0时，当月累计产量Dyljcl不能为0,分母不能为0");
        }
        //条件封装
        TProcessesAuxiliary tProcessesAuxiliary = new TProcessesAuxiliary();
        BeanUtils.copyProperties(query, tProcessesAuxiliary);
        //设置tag
        R r1 = itSysDictService.getTagDate(null);
        if (r1.getCode() != 0) {
            return R.failed(r1.getMsg());
        }
        tProcessesAuxiliary.setTag((String) r1.getData());
        //设置单耗
        if (query.getLjyl() == 0) {
            tProcessesAuxiliary.setDh(0D);
        } else {
            //强转失去精度，借助字符串
            float dh = query.getLjyl() / query.getDyljcl();
            tProcessesAuxiliary.setDh(Double.valueOf(String.valueOf(dh)));
        }
        //增加
        log.info(JSON.toJSONString(tProcessesAuxiliary));
        int insert = baseMapper.insert(tProcessesAuxiliary);
        if (insert > 0) {
            return R.ok("辅助工序中->增加成功");
        } else {
            log.error("辅助工序中->增加失败: {}", JSON.toJSONString(tProcessesAuxiliary));
            return R.failed("辅助工序中->增加失败");
        }
    }
}
