package cn.wise.sc.acquisition.business.service.impl;

import cn.wise.sc.acquisition.business.constant.Rcode;
import cn.wise.sc.acquisition.business.entity.TProcessesBlast;
import cn.wise.sc.acquisition.business.enumation.ProjectEnum;
import cn.wise.sc.acquisition.business.mapper.TProcessesBlastMapper;
import cn.wise.sc.acquisition.business.model.query.TProcessesBlastQuery;
import cn.wise.sc.acquisition.business.model.vo.TProcessesBlastVo;
import cn.wise.sc.acquisition.business.service.*;
import cn.wise.sc.acquisition.business.util.BeanUtilsNewCopy;
import cn.wise.sc.acquisition.business.util.DateUtil;
import cn.wise.sc.acquisition.business.wrapper.page.Query;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * <p>
 * 服务实现类  爆破工序
 * </p>
 *
 * @author renchao
 * @since 2021-04-29
 */
@Service
@Slf4j
public class TProcessesBlastServiceImpl extends ServiceImpl<TProcessesBlastMapper, TProcessesBlast> implements ITProcessesBlastService {

    @Autowired
    private ITMineStopeService itMineStopeService;

    @Autowired
    private ITProcessesBlastdesignHoleService itProcessesBlastdesignHoleService;

    @Autowired
    private ITProcessesDrillingService itProcessesDrillingService;

    @Autowired
    private ITSysDictService itSysDictService;

    @Override
    public R getPage(TProcessesBlastQuery tProcessesBlastQuery, Query query) {
        log.info(JSON.toJSONString(tProcessesBlastQuery));
        //参数校验
        //分页
        Page<TProcessesBlast> page = new Page<>(query.getPageNum(), query.getPageSize());
        //条件封装
        QueryWrapper<TProcessesBlast> queryWrapper = new QueryWrapper<>();

        //如果设计时间不为空 因为涉及到表连接，需要创建字段别名
        if (tProcessesBlastQuery.getBlastDate() != null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(ProjectEnum.TableAlias.A.getLabel()).append(ProjectEnum.TProcessesBlast.BLAST_DATE.getLabel());
            //前端传来的时间可能为2021-04-05 17:37:33.000, 需要查询 2021-04-05 00:00:00 到 2021-04-05 23:59:59 的数据 故作处理
            queryWrapper
                    .ge(stringBuilder.toString(), DateUtil.getBeginTimeStr(tProcessesBlastQuery.getBlastDate()))
                    .le(stringBuilder.toString(), DateUtil.getEndTimeStr(tProcessesBlastQuery.getBlastDate()));
        }
        //查询分页数据
        Page<TProcessesBlastVo> data = baseMapper.getPage(page, queryWrapper);
        return R.ok(data);
    }

    @Override
    public R updateByUid(TProcessesBlastQuery query) {
        log.info(JSON.toJSONString(query));
        //参数校验
        Rcode.NOT_PARAM.assertNotNull(query);
        Rcode.NOT_PARAM.assertNotNull(query.getUid());
        //判断数据是否存在
        TProcessesBlast temp = baseMapper.selectById(query.getUid());
        if (temp == null) {
            return R.failed("爆破设计中->数据不存在：uid：" + query.getUid());
        }
        //不能修改炮孔编号
        if (StringUtils.isNotBlank(query.getHoleID())) {
            return R.failed("爆破设计中->请到炮孔设计中修改炮孔编号");
        }
        //不能修改tag
        if (StringUtils.isNotBlank(query.getTag())) {
            return R.failed("爆破设计中->tag自动计算，不能修改");
        }
        //条件封装
        BeanUtilsNewCopy.copyPropertiesIgnoreNull(query, temp);
        //判断是否需要修改关联的 矿山爆区表
        if (StringUtils.isNotBlank(query.getStepName())
                || StringUtils.isNotBlank(query.getBlastAreaName())
                || StringUtils.isNotBlank(query.getStopeName())) {
            return R.failed("爆破设计中->请到炮孔设计中修改爆区名称，采区名称，平台名称");
            //判断矿山爆区表是否存在数据 不存在不能修改
            //query里不一定StopeName,StepName,BlastAreaName都有，需要从temp中拿query没有的，
            // 所以将query有的更新到temp中，再把temp中的复制到tMineStopeQuery
//            TMineStopeQuery tMineStopeQuery = new TMineStopeQuery();
//            BeanUtils.copyProperties(temp, tMineStopeQuery);
//            R volume = itMineStopeService.getByQuery(tMineStopeQuery);
//            if (volume.getData() == null) {
//                return R.failed("爆破设计中->矿山爆区表数据不存在，StopeName,StepName,BlastAreaName");
//            }
        }
        //判断是否修改设计孔深 和 单孔爆破量
        if (query.getDesignDepth() != null || query.getHoleBlastVolume() != null) {
            return R.failed("爆破设计中->请到炮孔设计中修改设计孔深和单孔爆破量");
//            TProcessesBlastdesignHoleQuery holeQuery = new TProcessesBlastdesignHoleQuery();
//            holeQuery.setBlastHoleID(temp.getHoleID());
//            holeQuery.setDepth(query.getDepth());
//            R r = itProcessesBlastdesignHoleService.updateByBlastHoleID(holeQuery);
//            if (r.getCode() != 0) {
//                log.error("修改炮孔设计失败：{}", JSON.toJSONString(holeQuery));
//                return R.failed(r.getMsg());
//            }
        }
        //判断是否修改实测孔深
        if (query.getDepth() != null) {
            return R.failed("爆破设计中->请到穿孔工序中修改实测孔深");
//            TProcessesDrillingQuery drillingQuery = new TProcessesDrillingQuery();
//            drillingQuery.setHoleID(temp.getHoleID());
//            drillingQuery.setDepth(query.getDepth());
//            R r = itProcessesDrillingService.updateByHoleId(drillingQuery);
//            if (r.getCode() != 0) {
//                log.error("修改穿孔工序失败：{}", JSON.toJSONString(drillingQuery));
//                return R.failed(r.getMsg());
//            }
        }
        QueryWrapper<TProcessesBlast> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq(StringUtils.isNotBlank(query.getUid()), ProjectEnum.TProcessesBlast.UID.getLabel(), query.getUid());
        //修改
        int update = baseMapper.update(temp, queryWrapper);
        if (update > 0) {
            return R.ok("爆破设计中->修改成功");
        } else {
            log.error("爆破设计中->修改失败:{}", JSON.toJSONString(temp));
            return R.failed("爆破设计中->修改失败");
        }
    }


    @Override
    public R insertTProcessesBlast(TProcessesBlastQuery query) {
        log.info(JSON.toJSONString(query));
        //参数校验
        Rcode.NOT_PARAM.assertNotNull(query);
        //不能修改tag
        if (StringUtils.isNotBlank(query.getTag())) {
            return R.failed("爆破设计中->tag自动计算，不能添加");
        }
        //条件封装
        TProcessesBlast tProcessesDrilling = new TProcessesBlast();
        BeanUtils.copyProperties(query, tProcessesDrilling);
        //设置tag
        R r1 = itSysDictService.getTagDate(null);
        if (r1.getCode() != 0) {
            return R.failed(r1.getMsg());
        }
        tProcessesDrilling.setTag((String) r1.getData());
        //增加
        int insert = baseMapper.insert(tProcessesDrilling);
        if (insert > 0) {
            return R.ok("爆破设计中->增加成功");
        } else {
            log.error("爆破设计中->增加失败:{}",JSON.toJSONString(tProcessesDrilling));
            return R.failed("爆破设计中->增加失败");
        }
    }

    @Override
    public R getByUid(TProcessesBlastQuery query) {
        log.info(JSON.toJSONString(query));
        //参数校验
        Rcode.NOT_PARAM.assertNotNull(query);
        Rcode.NOT_PARAM.assertNotEmpty(query.getUid());
        QueryWrapper<TProcessesBlast> queryWrapper = new QueryWrapper<>();
        StringBuilder uid = new StringBuilder();
        uid.append(ProjectEnum.TableAlias.A.getLabel()).append(ProjectEnum.TProcessesBlast.UID.getLabel());
        queryWrapper.eq(uid.toString(), query.getUid());
        //查询并且返回
        return R.ok(baseMapper.getByQuery(queryWrapper));
    }


}
