package cn.wise.sc.acquisition.business.service.impl;

import cn.wise.sc.acquisition.business.constant.Rcode;
import cn.wise.sc.acquisition.business.entity.TProcessesBlastdesignVolume;
import cn.wise.sc.acquisition.business.enumation.ProjectEnum;
import cn.wise.sc.acquisition.business.mapper.TProcessesBlastdesignVolumeMapper;
import cn.wise.sc.acquisition.business.model.query.TProcessesBlastdesignVolumeQuery;
import cn.wise.sc.acquisition.business.service.ITProcessesBlastdesignVolumeService;
import cn.wise.sc.acquisition.business.wrapper.page.Query;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;


/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author renchao
 * @since 2021-04-27
 */
@Service
@Slf4j
public class TProcessesBlastdesignVolumeServiceImpl extends ServiceImpl<TProcessesBlastdesignVolumeMapper, TProcessesBlastdesignVolume> implements ITProcessesBlastdesignVolumeService {

    @Override
    public R getPage(TProcessesBlastdesignVolumeQuery tProcessesBlastdesignHoleQuery, Query query) {
        log.info(JSON.toJSONString(tProcessesBlastdesignHoleQuery));
        //参数校验
        //分页
        Page<TProcessesBlastdesignVolume> page = new Page<>(query.getPageNum(), query.getPageSize());
        //条件封装
        QueryWrapper<TProcessesBlastdesignVolume> queryWrapper = new QueryWrapper<>();
        //暂时没有添加的筛选条件
        //查询
        Page<TProcessesBlastdesignVolume> tProcessesBlastdesignVolumePage = baseMapper.selectPage(page, queryWrapper);
        return R.ok(tProcessesBlastdesignVolumePage);
    }

    @Override
    public R updateByQuery(TProcessesBlastdesignVolumeQuery query) {
        log.info(JSON.toJSONString(query));
        //参数校验
        Rcode.NOT_PARAM.assertNotNull(query);
        Rcode.NOT_PARAM.assertNotEmpty(query.getStopeName());
        Rcode.NOT_PARAM.assertNotEmpty(query.getStepName());
        Rcode.NOT_PARAM.assertNotEmpty(query.getBlastAreaName());
        //判断数据是否存在
        R volume = getByQuery(query);
        if (volume.getData() == null) {
            return R.failed("设计爆区爆破量表中->设计爆区爆破量表数据不存在，StopeName,StepName,BlastAreaName");
        }
        //条件封装
        TProcessesBlastdesignVolume tProcessesBlastdesignVolume = new TProcessesBlastdesignVolume();
        BeanUtils.copyProperties(query, tProcessesBlastdesignVolume);

        QueryWrapper<TProcessesBlastdesignVolume> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq(ProjectEnum.TProcessesBlastdesignVolume.STOPE_NAME.getLabel(), query.getStopeName())
                .eq(ProjectEnum.TProcessesBlastdesignVolume.STEP_NAME.getLabel(), query.getStepName())
                .eq(ProjectEnum.TProcessesBlastdesignVolume.BLAST_AREA_NAME.getLabel(), query.getBlastAreaName());
        //修改
        int update = baseMapper.update(tProcessesBlastdesignVolume, queryWrapper);
        if (update > 0) {
            return R.ok("设计爆区爆破量表中->修改成功");
        } else {
            log.error("设计爆区爆破量表中->修改失败: {}",JSON.toJSONString(tProcessesBlastdesignVolume));
            return R.failed("设计爆区爆破量表中->修改失败");
        }
    }

    @Override
    public R getByQuery(TProcessesBlastdesignVolumeQuery query) {
        log.info(JSON.toJSONString(query));
        //参数校验
        Rcode.NOT_PARAM.assertNotNull(query);
        Rcode.NOT_PARAM.assertNotEmpty(query.getStopeName());
        Rcode.NOT_PARAM.assertNotEmpty(query.getStepName());
        Rcode.NOT_PARAM.assertNotEmpty(query.getBlastAreaName());
        //封装
        QueryWrapper<TProcessesBlastdesignVolume> queryWrapper = new QueryWrapper<>();
        queryWrapper
                .eq(ProjectEnum.TProcessesBlastdesignVolume.STOPE_NAME.getLabel(), query.getStopeName())
                .eq(ProjectEnum.TProcessesBlastdesignVolume.STEP_NAME.getLabel(), query.getStepName())
                .eq(ProjectEnum.TProcessesBlastdesignVolume.BLAST_AREA_NAME.getLabel(), query.getBlastAreaName());
        //查询并且返回
        return R.ok(baseMapper.selectOne(queryWrapper));
    }



}
