package cn.wise.sc.acquisition.business.service.impl;

import cn.wise.sc.acquisition.business.constant.Rcode;
import cn.wise.sc.acquisition.business.entity.TProcessesCrusher;
import cn.wise.sc.acquisition.business.enumation.ProjectEnum;
import cn.wise.sc.acquisition.business.mapper.TProcessesCrusherMapper;
import cn.wise.sc.acquisition.business.model.query.TProcessesCrusherQuery;
import cn.wise.sc.acquisition.business.model.vo.TProcessesCrusherVo;
import cn.wise.sc.acquisition.business.service.ITProcessesCrusherService;
import cn.wise.sc.acquisition.business.service.ITSysDictService;
import cn.wise.sc.acquisition.business.wrapper.page.Query;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author renchao
 * @since 2021-04-30
 */
@Service
@Slf4j
public class TProcessesCrusherServiceImpl extends ServiceImpl<TProcessesCrusherMapper, TProcessesCrusher> implements ITProcessesCrusherService {

    @Autowired
    private ITSysDictService itSysDictService;

    @Override
    public R getPage(TProcessesCrusherQuery tProcessesCrusherQuery, Query query) {
        log.info(JSON.toJSONString(tProcessesCrusherQuery));
        //参数校验
        //分页
        Page<TProcessesCrusher> page = new Page<>(query.getPageNum(), query.getPageSize());
        //条件封装
        QueryWrapper<TProcessesCrusher> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq(StringUtils.isNotBlank(tProcessesCrusherQuery.getEquipmentID()),
                ProjectEnum.TProcessesCrusher.EQUIPMENT_ID.getLabel(), tProcessesCrusherQuery.getEquipmentID());
        //查询
        Page<TProcessesCrusherVo> tSampleListPage = baseMapper.getPage(page, queryWrapper);
        return R.ok(tSampleListPage);
    }

    @Override
    public R getByUid(TProcessesCrusherQuery query) {
        log.info(JSON.toJSONString(query));
        //参数校验
        Rcode.NOT_PARAM.assertNotNull(query);
        Rcode.NOT_PARAM.assertNotNull(query.getUid());
        //查询并且返回
        QueryWrapper<TProcessesCrusher> queryWrapper = new QueryWrapper<>();
        StringBuilder uid = new StringBuilder();
        uid.append(ProjectEnum.TableAlias.A.getLabel()).append(ProjectEnum.TProcessesCrusher.UID.getLabel());
        queryWrapper.eq(uid.toString(), query.getUid());
        //查询并且返回
        return R.ok(baseMapper.getByQuery(queryWrapper));
    }

    @Override
    public R updateByUid(TProcessesCrusherQuery query) {

        log.info(JSON.toJSONString(query));
        //参数校验
        Rcode.NOT_PARAM.assertNotNull(query);
        Rcode.NOT_PARAM.assertNotNull(query.getUid());
        //判断数据是否存在
        TProcessesCrusher temp = baseMapper.selectById(query.getUid());
        if (temp == null) {
            return R.failed("破碎工序中->数据不存在，uid：" + query.getUid());
        }
        if (StringUtils.isNotBlank(query.getTag())) {
            return R.failed("破碎工序中->标注日期为自动生成，tag不能修改");
        }
        //条件封装
        TProcessesCrusher tSampleList = new TProcessesCrusher();
        BeanUtils.copyProperties(query, tSampleList);

        QueryWrapper<TProcessesCrusher> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq(StringUtils.isNotBlank(query.getUid()), ProjectEnum.TProcessesCrusher.UID.getLabel(), query.getUid());
        //修改
        int update = baseMapper.update(tSampleList, queryWrapper);
        if (update > 0) {
            return R.ok("破碎工序中->修改成功");
        } else {
            log.error("破碎工序中->修改失败:{}",JSON.toJSONString(tSampleList));
            return R.failed("破碎工序中->修改失败");
        }

    }

    @Override
    public R insertTProcessesCrusher(TProcessesCrusherQuery query) {
        log.info(JSON.toJSONString(query));
        //参数校验
        Rcode.NOT_PARAM.assertNotNull(query);
        //uid自动生成 不能手动设置
        if (query.getUid() != null) {
            return R.failed("破碎工序中->uid自动生成 不能手动设置");
        }
        if (StringUtils.isNotBlank(query.getTag())) {
            return R.failed("破碎工序中->标注日期为自动生成，tag不能修改");
        }
        //条件封装
        TProcessesCrusher tProcessesCrusher = new TProcessesCrusher();
        BeanUtils.copyProperties(query, tProcessesCrusher);
        //设置标注日期
        R r1 = itSysDictService.getTagDate(null);
        if (r1.getCode() != 0) {
            return R.failed(r1.getMsg());
        }
        tProcessesCrusher.setTag((String) r1.getData());
        //增加
        log.info(JSON.toJSONString(tProcessesCrusher));
        int insert = baseMapper.insert(tProcessesCrusher);
        if (insert > 0) {
            return R.ok("破碎工序中->增加成功");
        } else {
            log.error("破碎工序中->增加失败 : {}",JSON.toJSONString(tProcessesCrusher));
            return R.failed("破碎工序中->增加失败");
        }
    }


}
