package cn.wise.sc.acquisition.business.service.impl;

import cn.wise.im.common.http.R;
import cn.wise.im.common.http.ResponseEnum;
import cn.wise.sc.acquisition.business.constant.Rcode;
import cn.wise.sc.acquisition.business.entity.TEquipmentAccount;
import cn.wise.sc.acquisition.business.entity.TProcessesDigging;
import cn.wise.sc.acquisition.business.mapper.TProcessesDiggingMapper;
import cn.wise.sc.acquisition.business.model.PageQuery;
import cn.wise.sc.acquisition.business.model.query.TEquipmentAccountQuery;
import cn.wise.sc.acquisition.business.model.query.TProcessesDiggingQuery;
import cn.wise.sc.acquisition.business.service.ITProcessesDiggingService;
import cn.wise.sc.acquisition.business.service.ITSysDictService;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author ztw
 * @since 2021-04-28
 */
@Service
@Transactional
public class TProcessesDiggingServiceImpl extends ServiceImpl<TProcessesDiggingMapper, TProcessesDigging> implements ITProcessesDiggingService {

    @Resource
    private TProcessesDiggingMapper processesDiggingMapper;

    @Autowired
    private ITSysDictService itSysDictService;

    /**
     * 今日数量统计
     *
     * @param digDate
     * @return
     */
    @Override
    public R getTodayData(String digDate) {
        Map<String, Object> map = new HashMap<>();
        QueryWrapper<TProcessesDigging> qw = new QueryWrapper<>();
        if (StringUtils.isNoneBlank(digDate)) {
            qw.apply("DATE(DigDate) = digDate");
        } else {
            qw.apply("DATE(DigDate) = DATE(now())");
        }
        List<TProcessesDigging> list = processesDiggingMapper.selectList(qw);
        Float workTimes = list.stream().map(p -> p.getWorkTime()).reduce(Float::sum).get();
        Double workLoads = list.stream().mapToDouble(TProcessesDigging::getWorkload).sum();
        map.put("workTimes", workTimes);
        map.put("workLoads", workLoads);
        return R.ok(map);

    }

    /**
     * 分页列表
     *
     * @param pageQuery
     * @param digDate
     * @return
     */
    @Override
    public R<IPage<TProcessesDigging>> getPage(PageQuery pageQuery, String digDate) {
        QueryWrapper<TProcessesDigging> qw = new QueryWrapper<>();
        if (StringUtils.isNoneBlank(digDate)) {
            try {
                SimpleDateFormat formatter = new SimpleDateFormat(
                        "yyyy-MM-dd HH:mm:ss");
                String startDate = digDate + " 00:00:00";
                String endDate = digDate + " 23:59:59";
                qw.between("DigDate", formatter.parse(startDate), formatter.parse(endDate));
            } catch (ParseException e) {
                e.printStackTrace();
            }
        }
        qw.orderByDesc("DigDate");
        IPage<TProcessesDigging> page = new Page<>(pageQuery.getPageNo(), pageQuery.getPageSize());
        page = processesDiggingMapper.selectPage(page, qw);
        return R.ok(page);
    }

    /**
     * 新增
     *
     * @param query
     * @return
     */
    @Override
    public R save(TProcessesDiggingQuery query) {
        Rcode.NOT_PARAM.assertNotNull(query);
        Rcode.NOT_PARAM.assertNotNull(query.getStopeName());
        Rcode.NOT_PARAM.assertNotNull(query.getStepName());
        Rcode.NOT_PARAM.assertNotNull(query.getBlastAreaName());
        if (StringUtils.isNotBlank(query.getTag())) {
            return R.fail(ResponseEnum.FAIL, "装车工序中->tag不能添加");
        }
        TProcessesDigging digging = new TProcessesDigging();
        BeanUtils.copyProperties(query, digging);
        //设置tag
        com.baomidou.mybatisplus.extension.api.R r = itSysDictService.getTagDate(null);
        if (r.getCode() != 0) {
            return R.fail(ResponseEnum.FAIL, r.getMsg());
        }
        digging.setTag((String) r.getData());
        processesDiggingMapper.insert(digging);
        return R.ok();
    }

    /**
     * 修改
     *
     * @param query
     * @return
     */
    @Override
    public R update(TProcessesDiggingQuery query) {
        Rcode.NOT_PARAM.assertNotNull(query);
        Rcode.NOT_PARAM.assertNotNull(query.getUid());
        if (StringUtils.isNotBlank(query.getTag())) {
            return R.fail(ResponseEnum.FAIL, "装车工序中->tag不能修改");
        }
        TProcessesDigging digging = processesDiggingMapper.selectById(query.getUid());
        Rcode.NOT_FOUND.assertNotNull(digging);
        BeanUtils.copyProperties(query, digging);
        processesDiggingMapper.updateById(digging);
        return R.ok();
    }

    /**
     * 详情
     *
     * @param Uid
     * @return
     */
    @Override
    public R<TProcessesDigging> getDetail(String Uid) {
        Rcode.NOT_PARAM.assertNotNull(Uid);
        TProcessesDigging digging = processesDiggingMapper.selectById(Uid);
        Rcode.NOT_FOUND.assertNotNull(digging);
        return R.ok(digging);
    }


}
