package cn.wise.sc.acquisition.business.service.impl;

import cn.wise.im.common.http.R;
import cn.wise.im.common.http.ResponseEnum;
import cn.wise.sc.acquisition.business.constant.Rcode;
import cn.wise.sc.acquisition.business.entity.TProcessesTruck;
import cn.wise.sc.acquisition.business.entity.TProcessesTruck;
import cn.wise.sc.acquisition.business.mapper.TProcessesTruckMapper;
import cn.wise.sc.acquisition.business.model.PageQuery;
import cn.wise.sc.acquisition.business.model.query.TProcessesTruckQuery;
import cn.wise.sc.acquisition.business.service.ITProcessesTruckService;
import cn.wise.sc.acquisition.business.service.ITSysDictService;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>
 *  服务实现类
 * </p>
 *
 * @author ztw
 * @since 2021-04-26
 */
@Service
public class TProcessesTruckServiceImpl extends ServiceImpl<TProcessesTruckMapper, TProcessesTruck> implements ITProcessesTruckService {

	@Resource
	private TProcessesTruckMapper processesTruckMapper;

	@Autowired
	private ITSysDictService itSysDictService;
	/**
	 * 今日数量统计
	 * @param deliveryDate
	 * @return
	 */
	@Override
	public R getTodayData(String deliveryDate){
		Map<String,Object> map = new HashMap<>();
		QueryWrapper<TProcessesTruck> qw = new QueryWrapper<>();
		if(StringUtils.isNoneBlank(deliveryDate)){
			qw.apply("DATE(DeliveryDate) = deliveryDate");
		}else{
			qw.apply("DATE(DeliveryDate) = DATE(now())");
		}
		List<TProcessesTruck> list =  processesTruckMapper.selectList(qw);
		Integer cshjs = list.stream().map(p -> p.getCshj()).reduce(Integer::sum).get();
		Double dwhjs = list.stream().mapToDouble(TProcessesTruck::getDwhj).sum();
		map.put("cshjs",cshjs);
		map.put("dwhjs",dwhjs);
		return R.ok(map);

	}

	/**
	 * 分页列表
	 * @param pageQuery
	 * @param deliveryDate
	 * @return
	 */
	@Override
	public R<IPage<TProcessesTruck>> getPage(PageQuery pageQuery, String deliveryDate) {
		QueryWrapper<TProcessesTruck> qw = new QueryWrapper<>();
		if (StringUtils.isNoneBlank(deliveryDate)) {
			try {
				SimpleDateFormat formatter = new SimpleDateFormat(
						"yyyy-MM-dd HH:mm:ss");
				String startDate = deliveryDate + " 00:00:00";
				String endDate = deliveryDate + " 23:59:59";
				qw.between("DeliveryDate",formatter.parse(startDate), formatter.parse(endDate));
			} catch (ParseException e) {
				e.printStackTrace();
			}
		}

		/*if(StringUtils.isNoneBlank(deliveryDate)){
			qw.apply("DATE(DeliveryDate) = DATE("+deliveryDate+")");
		}*/
		qw.orderByDesc("DeliveryDate");
		IPage<TProcessesTruck> page = new Page<>(pageQuery.getPageNo(), pageQuery.getPageSize());
		page = processesTruckMapper.selectPage(page, qw);
		return R.ok(page);
	}

	/**
	 * 新增
	 * @param query
	 * @return
	 */
	@Override
	public R save(TProcessesTruckQuery query){
		Rcode.NOT_PARAM.assertNotNull(query);
		Rcode.NOT_PARAM.assertNotNull(query.getStopeName());
		Rcode.NOT_PARAM.assertNotNull(query.getStepName());
		Rcode.NOT_PARAM.assertNotNull(query.getBlastAreaName());
		if (StringUtils.isNotBlank(query.getTag())){
			return R.fail(ResponseEnum.FAIL,"运输工序中->tag不能添加");
		}
		TProcessesTruck truck = new TProcessesTruck();
		BeanUtils.copyProperties(query, truck);
		com.baomidou.mybatisplus.extension.api.R r = itSysDictService.getTagDate(null);
		if (r.getCode()!=0){
			return R.fail(ResponseEnum.FAIL,r.getMsg());
		}
		truck.setTag((String) r.getData());
		processesTruckMapper.insert(truck);
		return R.ok();
	}

	/**
	 * 修改
	 * @param query
	 * @return
	 */
	@Override
	public R update(TProcessesTruckQuery query) {
		Rcode.NOT_PARAM.assertNotNull(query);
		Rcode.NOT_PARAM.assertNotNull(query.getUid());
		if (StringUtils.isNotBlank(query.getTag())){
			return R.fail(ResponseEnum.FAIL,"运输工序中->tag不能修改");
		}
		TProcessesTruck digging = processesTruckMapper.selectById(query.getUid());
		Rcode.NOT_FOUND.assertNotNull(digging);
		BeanUtils.copyProperties(query, digging);

		processesTruckMapper.updateById(digging);
		return R.ok();
	}

	/**
	 * 详情
	 * @param Uid
	 * @return
	 */
	@Override
	public R<TProcessesTruck> getDetail(String Uid) {
		Rcode.NOT_PARAM.assertNotNull(Uid);
		TProcessesTruck digging = processesTruckMapper.selectById(Uid);
		Rcode.NOT_FOUND.assertNotNull(digging);
		return R.ok(digging);
	}


}
