package cn.wise.sc.acquisition.business.service.impl;

import cn.wise.im.common.http.R;
import cn.wise.sc.acquisition.business.constant.Rcode;
import cn.wise.sc.acquisition.business.entity.*;
import cn.wise.sc.acquisition.business.enumation.FileExt;
import cn.wise.sc.acquisition.business.mapper.TSafeTroubleImgMapper;
import cn.wise.sc.acquisition.business.mapper.TSafeTroubleMapper;
import cn.wise.sc.acquisition.business.model.LoginUser;
import cn.wise.sc.acquisition.business.model.PageQuery;
import cn.wise.sc.acquisition.business.model.query.TMaterialOutQuery;
import cn.wise.sc.acquisition.business.model.query.TSafeTroubleQuery;
import cn.wise.sc.acquisition.business.model.vo.TSafeTroubleVo;
import cn.wise.sc.acquisition.business.service.ITSafeTroubleService;
import cn.wise.sc.acquisition.business.util.ImageUtil;
import cn.wise.sc.acquisition.business.util.dfs.FastDFSUtils;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import io.swagger.annotations.ApiOperation;
import io.swagger.models.auth.In;
import org.apache.tomcat.util.http.fileupload.servlet.ServletFileUpload;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * <p>
 *  服务实现类
 * </p>
 *
 * @author renchao
 * @since 2021-04-27
 */
@Service
@Transactional
public class TSafeTroubleServiceImpl extends ServiceImpl<TSafeTroubleMapper, TSafeTrouble> implements ITSafeTroubleService {

	@Resource
	private TSafeTroubleMapper safeTroubleMapper;
	@Resource
	private TSafeTroubleImgMapper safeTroubleImgMapper;

	/**
	 * 安全台账分页
	 * @param pageQuery
	 * @return
	 */
	@Override
	public R<IPage<TSafeTrouble>> getPage(PageQuery pageQuery) {
		QueryWrapper<TSafeTrouble> qw = new QueryWrapper<>();
		qw.orderByDesc("Fxrq");
		IPage<TSafeTrouble> page = new Page<>(pageQuery.getPageNo(), pageQuery.getPageSize());
		page = safeTroubleMapper.selectPage(page, qw);
		return R.ok(page);
	}


	/**
	 * 添加隐患
	 * @param query
	 * @return
	 */
	@Override
	public R save(TSafeTroubleQuery query, HttpServletRequest request) {
		Rcode.NOT_PARAM.assertNotNull(query);
		TSafeTrouble safeTrouble = new TSafeTrouble();
		BeanUtils.copyProperties(query, safeTrouble);
		safeTroubleMapper.insert(safeTrouble);

		Boolean ret = ServletFileUpload.isMultipartContent(request);
		//保存隐患图片 变量名称只能用file  不能修改
		if(ret){
			List<MultipartFile>  photos = ((MultipartHttpServletRequest) request).getFiles("file");
			if (photos != null && photos.size() > 0) {
				return saveImg(TSafeTroubleImg.ImgType.YH, safeTrouble.getUid(),  photos);
			}
		}

		return R.ok();
	}


	/**
	 * 隐患整改
	 * @param query
	 * @return
	 */
	@Override
	public R update(TSafeTroubleQuery query,HttpServletRequest request) {
		Rcode.NOT_PARAM.assertNotNull(query);
		Rcode.NOT_PARAM.assertNotNull(query.getUid());
		TSafeTrouble safeTrouble = safeTroubleMapper.selectById(query.getUid());
		Rcode.NOT_FOUND.assertNotNull(safeTrouble);
		BeanUtils.copyProperties(query, safeTrouble);
		safeTroubleMapper.updateById(safeTrouble);

		Boolean ret = ServletFileUpload.isMultipartContent(request);
		//保存隐患图片 变量名称只能用file  不能修改
		if(ret){
			List<MultipartFile>  photos = ((MultipartHttpServletRequest) request).getFiles("file");
			if (photos != null && photos.size() > 0) {
				return saveImg(TSafeTroubleImg.ImgType.ZG, safeTrouble.getUid(),  photos);
			}
		}

		return R.ok();
	}


	/**
	 * 保存隐患图片信息
	 * @param imgType 隐患图片类型 ,分为隐患照片和整改后照片两类
	 * @param Uid   隐患表id
	 * @param photos  相片列表
	 * @return
	 */
	private R saveImg(String imgType, String Uid, List<MultipartFile> photos){
		if (photos != null && photos.size() > 0) {
			for (MultipartFile file : photos) {
				boolean ref = ImageUtil.checkFileSize( file.getSize(),30,"M");
				if(!ref){
					return R.fail(400, "文件不能大于30M");
				}
				TSafeTroubleImg safeTroubleImg = new TSafeTroubleImg();
				safeTroubleImg.setTroubleUid(Uid)
						.setImg(ImageUtil.transformByte(file))
						.setImgType(imgType);
				safeTroubleImgMapper.insert(safeTroubleImg);
			}
		}
		return R.ok();
	}

	/**
	 * 隐患详情
	 * @param Uid
	 * @return
	 */
	@Override
	public R<TSafeTroubleVo> getDetail(String Uid) {
		Rcode.NOT_PARAM.assertNotNull(Uid);

		TSafeTrouble safeTrouble = safeTroubleMapper.selectById(Uid);
		Rcode.NOT_FOUND.assertNotNull(safeTrouble);
		TSafeTroubleVo safeTroubleVo = new TSafeTroubleVo();
		BeanUtils.copyProperties(safeTrouble, safeTroubleVo);

		QueryWrapper<TSafeTroubleImg> imgWrapper = new QueryWrapper<>();
		imgWrapper.eq("TroubleUid", safeTroubleVo.getUid());
		List<TSafeTroubleImg> checkList = safeTroubleImgMapper.selectList(imgWrapper);
		//整改前照片
		List<TSafeTroubleImg> oldImgs =  checkList.stream()
				.filter(arg -> arg.getImgType().equals(TSafeTroubleImg.ImgType.YH)).collect(Collectors.toList());
		safeTroubleVo.setOldImgs(oldImgs);
		//整改后照片
		List<TSafeTroubleImg> newImgs =  checkList.stream()
				.filter(arg -> arg.getImgType().equals(TSafeTroubleImg.ImgType.ZG)).collect(Collectors.toList());
		safeTroubleVo.setNewImgs(newImgs);


		return R.ok(safeTroubleVo);
	}





}
