package cn.wise.sc.acquisition.business.service.impl;

import cn.wise.sc.acquisition.business.constant.Rcode;
import cn.wise.sc.acquisition.business.entity.TSampleLaboratorysheet;
import cn.wise.sc.acquisition.business.enumation.ProjectEnum;
import cn.wise.sc.acquisition.business.mapper.TSampleLaboratorysheetMapper;
import cn.wise.sc.acquisition.business.model.query.TSampleLaboratorysheetQuery;
import cn.wise.sc.acquisition.business.model.query.TSampleListQuery;
import cn.wise.sc.acquisition.business.service.ITSampleLaboratorysheetService;
import cn.wise.sc.acquisition.business.service.ITSampleListService;
import cn.wise.sc.acquisition.business.util.ImageUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletResponse;
import java.time.format.DateTimeFormatter;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author renchao
 * @since 2021-04-25
 */
@Service
@Slf4j
public class TSampleLaboratorysheetServiceImpl extends ServiceImpl<TSampleLaboratorysheetMapper, TSampleLaboratorysheet> implements ITSampleLaboratorysheetService {

    @Autowired
    private ITSampleListService tSampleListService;

    @Override
    public R getByYh(TSampleLaboratorysheetQuery query) {
        log.info(JSON.toJSONString(query));
        //参数校验
        Rcode.NOT_PARAM.assertNotNull(query);
        Rcode.NOT_PARAM.assertNotEmpty(query.getYh());
        TSampleLaboratorysheet tSampleLaboratorysheet = baseMapper.selectById(query.getYh());
        return R.ok(tSampleLaboratorysheet);
    }


    @Override
    public R updateByYh(TSampleLaboratorysheetQuery query) {
        log.info(JSON.toJSONString(query));
        //参数校验
        Rcode.NOT_PARAM.assertNotNull(query);
        Rcode.NOT_PARAM.assertNotEmpty(query.getYh());
        //查询数据
        TSampleLaboratorysheet tSampleLaboratorysheet = baseMapper.selectById(query.getYh());
        if (tSampleLaboratorysheet == null) {
            return R.failed("结果分析单中->数据不存在，样号：" + query.getYh());
        }
        //封装
        tSampleLaboratorysheet = new TSampleLaboratorysheet();
        BeanUtils.copyProperties(query, tSampleLaboratorysheet);
        int update = baseMapper.updateById(tSampleLaboratorysheet);
        if (update > 0) {
            return R.ok("结果分析单中->修改成功");
        } else {
            log.error("结果分析单中->修改失败: {}",JSON.toJSONString(tSampleLaboratorysheet));
            return R.failed("结果分析单中->修改失败");
        }
    }

    @Override
    public R deleteByYh(TSampleLaboratorysheetQuery query) {
        log.info(JSON.toJSONString(query));
        //参数校验
        Rcode.NOT_PARAM.assertNotNull(query);
        Rcode.NOT_PARAM.assertNotEmpty(query.getYh());
        //查询数据
        TSampleLaboratorysheet tSampleLaboratorysheet = baseMapper.selectById(query.getYh());
        if (tSampleLaboratorysheet == null) {
            return R.failed("结果分析单中->数据不存在，样号：" + query.getYh());
        }
        //删除
        int delete = baseMapper.deleteById(query.getYh());
        if (delete > 0) {
            return R.ok("结果分析单中->修改成功");
        } else {
            return R.failed("结果分析单中->修改失败");
        }
    }

    @Override
    public R insertTSampleLaboratorysheet(TSampleLaboratorysheetQuery query) {
        log.info(JSON.toJSONString(query));
        //参数校验
        Rcode.NOT_PARAM.assertNotNull(query);
        Rcode.NOT_PARAM.assertNotEmpty(query.getYh());
        //判断是否存在送样号
        R temp = tSampleListService.getByYh(new TSampleListQuery(query.getYh()));
        if (temp.getData() == null) {
            return R.failed("结果分析单中->送验单不存在，样号：" + query.getYh());
        }
        //判断是否已经存在分析结果单
        R temp1 = getByYh(query);
        if (temp1.getData() != null) {
            return R.failed("结果分析单中->分析结果样号已存在，样号：" + query.getYh());
        }

        //继续判断参数
        Rcode.NOT_PARAM.assertNotEmpty(query.getLaboratoryID());
        Rcode.NOT_PARAM.assertNotNull(query.getSysj());
        Rcode.NOT_PARAM.assertNotNull(query.getHysj());
        Rcode.NOT_PARAM.assertNotEmpty(query.getHyr());
        Rcode.NOT_PARAM.assertNotEmpty(query.getFpcfwz());
        Rcode.NOT_PARAM.assertNotNull(query.getCao());
        Rcode.NOT_PARAM.assertNotNull(query.getMgO());
        Rcode.NOT_PARAM.assertNotNull(query.getSiO2());
        Rcode.NOT_PARAM.assertNotNull(query.getAl2O3());
        Rcode.NOT_PARAM.assertNotNull(query.getFe2O3());
        Rcode.NOT_PARAM.assertNotNull(query.getK2o());
        Rcode.NOT_PARAM.assertNotNull(query.getNa2O());
        Rcode.NOT_PARAM.assertNotNull(query.getSo3());
        Rcode.NOT_PARAM.assertNotNull(query.getCl());
        Rcode.NOT_PARAM.assertNotNull(query.getSsl());
        //封装
        TSampleLaboratorysheet tSampleLaboratorysheet = new TSampleLaboratorysheet();
        BeanUtils.copyProperties(query, tSampleLaboratorysheet);
        //生成二维码 并且保存
        //tSampleLaboratorysheet.setQRCode(ImageUtil.QRCodeGenerator(JSON.toJSONString(tSampleLaboratorysheet)));
        //保存
        int insert = baseMapper.insert(tSampleLaboratorysheet);
        if (insert > 0) {
            return R.ok("结果分析单中->添加成功");
        } else {
            log.info(JSON.toJSONString(tSampleLaboratorysheet));
            return R.failed("结果分析单中->添加失败");
        }
    }


    /**
     * 获取图片二维码
     *
     * @param query
     * @param response
     */
    @Override
    @Transactional
    public R getImage(TSampleLaboratorysheetQuery query, final HttpServletResponse response) {
        log.info(JSON.toJSONString(query));
        //参加校验
        Rcode.NOT_PARAM.assertNotNull(query);
        Rcode.NOT_PARAM.assertNotEmpty(query.getYh());
        //查询
        TSampleLaboratorysheet tSampleLaboratorysheet = baseMapper.selectById(query.getYh());
        if (tSampleLaboratorysheet == null) {
            return R.failed("结果分析单中->数据不存在，样号：" + query.getYh());
        }
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        String content = "";
        if(tSampleLaboratorysheet != null){
            //上标 下标 ₀ ₁ ₂ ₃ ₄ ₅ ₆ ₇ ₈ ₉ ⁻
            String yh = "样号："+( tSampleLaboratorysheet.getYh()!= null?tSampleLaboratorysheet.getYh():"") +" \n ";
            content = yh+
                    "化验室编号："+( tSampleLaboratorysheet.getLaboratoryID()!= null?tSampleLaboratorysheet.getLaboratoryID():"")  +" \n "+
                    "CaO："+( tSampleLaboratorysheet.getCao()!= null?tSampleLaboratorysheet.getCao():"")  +" \n "+
                    "MgO："+( tSampleLaboratorysheet.getMgO()!= null?tSampleLaboratorysheet.getMgO():"")  +" \n "+
                    "SiO₂："+( tSampleLaboratorysheet.getSiO2()!= null?tSampleLaboratorysheet.getSiO2():"")  +" \n "+
                    "Al₂O₃："+( tSampleLaboratorysheet.getAl2O3()!= null?tSampleLaboratorysheet.getAl2O3():"") +" \n "+
                    "Fe₂O₃："+( tSampleLaboratorysheet.getFe2O3()!= null?tSampleLaboratorysheet.getFe2O3():"") +" \n "+
                    "K₂O："+( tSampleLaboratorysheet.getK2o()!= null?tSampleLaboratorysheet.getK2o():"") +" \n "+
                    "Na₂O："+( tSampleLaboratorysheet.getNa2O()!= null?tSampleLaboratorysheet.getNa2O():"") +" \n "+
                    "SO₃："+( tSampleLaboratorysheet.getSo3()!= null?tSampleLaboratorysheet.getSo3():"") +" \n "+
                    "Cl⁻："+( tSampleLaboratorysheet.getCl()!= null?tSampleLaboratorysheet.getCl():"") +" \n "+
                    "烧失量："+( tSampleLaboratorysheet.getSsl()!= null?tSampleLaboratorysheet.getSsl():"") +" \n "+
                    "收样时间："+( tSampleLaboratorysheet.getSysj()!= null?df.format(tSampleLaboratorysheet.getSysj()):"") +" \n "+
                    "化验人："+( tSampleLaboratorysheet.getHyr()!= null?tSampleLaboratorysheet.getHyr():"") +" \n "+
                    "化验时间："+( tSampleLaboratorysheet.getHysj()!= null?df.format(tSampleLaboratorysheet.getHysj()):"");
        }

        //获取二维码或者记录形式
        //先生成二维码并且放到实体中
//        tSampleLaboratorysheet.setQRCode(ImageUtil.QRCodeGenerator(JSON.toJSONString(tSampleLaboratorysheet)));
        tSampleLaboratorysheet.setQRCode(ImageUtil.QRCodeGenerator(content));

        //下载图片
        ImageUtil.getImage(ProjectEnum.ImageType.QR_CODE.getValue(), tSampleLaboratorysheet, response);
        //如果下载失败才会执行return
        return R.failed("结果分析单中->该条数据没有图片");
    }
}
