package cn.wise.sc.acquisition.business.service.impl;

import cn.wise.sc.acquisition.business.entity.TSysDict;
import cn.wise.sc.acquisition.business.enumation.ProjectEnum;
import cn.wise.sc.acquisition.business.mapper.TSysDictMapper;
import cn.wise.sc.acquisition.business.model.query.TSysDictQuery;
import cn.wise.sc.acquisition.business.service.ITSysDictService;
import cn.wise.sc.acquisition.business.util.DateUtil;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author ztw
 * @since 2021-04-23
 */
@Service
public class TSysDictServiceImpl extends ServiceImpl<TSysDictMapper, TSysDict> implements ITSysDictService {

    /**
     * 获取标注日期，将字典中id为6的数据的name字段做比较，
     * 大于name字段记录下一个月，小于该字段记录本月
     *
     * @param tSysDictQuery
     * @return
     */
    @Override
    public R getTagDate(TSysDictQuery tSysDictQuery) {
        //获取标注日期，将字典中id为6的数据的name字段做比较
        //大于name字段记录下一个月，小于该字段记录本月
        //获取id为6的字典
        TSysDict tSysDict = baseMapper.selectById(ProjectEnum.TSysDict.SIX.getValue());
        if (tSysDict == null || StringUtils.isBlank(tSysDict.getName())) {
            return R.failed("数据字典中->不存在id为6的数据");
        }
        //将name转化为integer
        Integer tagDate;
        try {
            tagDate = Integer.valueOf(tSysDict.getName());
        } catch (Exception e) {
            e.printStackTrace();
            return R.failed("数据字典中->name字段转化为integer失败,数据为null或者不为数字");
        }
        //获取当前时间的几号
        LocalDateTime now = LocalDateTime.now();
        int dayOfMonth = now.getDayOfMonth();
        //如果当天日期小于id为6的数据name字段为记录为本月，如果大于等于id为6的数据name字段  记录为下个月
        String format = "yyyy年MM月";
        if (dayOfMonth >= tagDate) {
            //下一个月
            now.plusMonths(1);
            return R.ok(DateUtil.timeToStr(now, format));
        } else {
            //本月
            return R.ok(DateUtil.timeToStr(now, format));
        }
    }

}
