package cn.wise.sc.acquisition.business.service.impl;

import cn.wise.sc.acquisition.business.constant.Rcode;
import cn.wise.sc.acquisition.business.entity.TWeight;
import cn.wise.sc.acquisition.business.enumation.ProjectEnum;
import cn.wise.sc.acquisition.business.mapper.TWeightMapper;
import cn.wise.sc.acquisition.business.model.query.TWeightQuery;
import cn.wise.sc.acquisition.business.service.ITWeightService;
import cn.wise.sc.acquisition.business.util.DateUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author ztw
 * @since 2021-04-26
 */
@Service
@Slf4j
public class TWeightServiceImpl extends ServiceImpl<TWeightMapper, TWeight> implements ITWeightService {


    @Override
    public R getByQuery(TWeightQuery query) {
        return null;
    }

    @Override
    public R getSumJz(TWeightQuery query) {
        log.info(JSON.toJSONString(query));
        //参数校验
        Rcode.NOT_PARAM.assertNotNull(query);
        QueryWrapper<TWeight> queryWrapper = new QueryWrapper<>();
        if (query.getRq() != null) {
            queryWrapper
                    .ge(ProjectEnum.TWeight.RQ.getLabel(), DateUtil.getBeginTimeStr(query.getRq()))
                    .le(ProjectEnum.TWeight.RQ.getLabel(), DateUtil.getEndTimeStr(query.getRq()));
        }
        //查询
        Double depthSum = baseMapper.getSumByCondition(new StringBuffer()
                .append(ProjectEnum.TableAlias.A.getLabel())
                .append(ProjectEnum.TWeight.JZ.getLabel()).toString(), queryWrapper);
        return R.ok(depthSum);
    }


}
