package cn.wise.sc.acquisition.business.util;

import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;

import java.util.HashSet;
import java.util.Set;

/**
 * author: renchao
 */
public class BeanUtilsNewCopy {

    /**
     * 获取对象属性
     * @param source
     * @return
     */
    private static String[] getNullPropertyNames (Object source) {
        final BeanWrapper src = new BeanWrapperImpl(source);
        java.beans.PropertyDescriptor[] pds = src.getPropertyDescriptors();

        Set<String> emptyNames = new HashSet<String>();
        for(java.beans.PropertyDescriptor pd : pds) {
            Object srcValue = src.getPropertyValue(pd.getName());
            if (srcValue == null) emptyNames.add(pd.getName());
        }
        String[] result = new String[emptyNames.size()];
        return emptyNames.toArray(result);
    }

    /**
     * 封装同名称属性复制，但是空属性不复制过去
     * @param src
     * @param target
     */
    public static void copyPropertiesIgnoreNull(Object src, Object target){
       BeanUtils.copyProperties(src, target, getNullPropertyNames(src));
    }

}
