package cn.wise.sc.acquisition.business.util;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 用ThreadLocal来存储resquest
 */
public class GlobalHolder {

	private static ThreadLocal<HttpServletRequest> requestThreadLocalHolder = new ThreadLocal<HttpServletRequest>();
	private static ThreadLocal<HttpServletResponse> responseThreadLocalHolder = new ThreadLocal<HttpServletResponse>();

	public static void setHttpRequest(HttpServletRequest request) {

		requestThreadLocalHolder.set(request);
	}

	public static void setHttpResponse(HttpServletResponse response) {
		responseThreadLocalHolder.set(response);
	}

	public static void remove() {
		requestThreadLocalHolder.remove();
		responseThreadLocalHolder.remove();
	}

	public static HttpServletResponse getHttpResponse() {

		return responseThreadLocalHolder.get();
	}

	public static HttpServletRequest getHttpRequest() {
		return requestThreadLocalHolder.get();
	}

	public static String corpId() {
		HttpServletRequest request = requestThreadLocalHolder.get();
		//前台传递值
		return request.getHeader("corpId");
	}
}
