package cn.wise.im.common.exception.assertion;

import cn.hutool.core.util.ArrayUtil;
import cn.wise.im.common.currency.IResponseEnum;
import cn.wise.im.common.exception.ArgumentException;
import cn.wise.im.common.exception.BaseException;
import java.text.MessageFormat;

/**
 * <pre>
 *参数异常断言
 * </pre>
 */
public interface ArgumentExceptionAssert extends IResponseEnum, Assert {

    @Override
    default BaseException newException(Object... args) {
        String msg = this.getMessage();
        if (ArrayUtil.isNotEmpty(args)) {
            msg = MessageFormat.format(this.getMessage(), args);
        }

        return new ArgumentException(this, args, msg);
    }

    @Override
    default BaseException newException(Throwable t, Object... args) {
        String msg = this.getMessage();
        if (ArrayUtil.isNotEmpty(args)) {
            msg = MessageFormat.format(this.getMessage(), args);
        }

        return new ArgumentException(this, args, msg, t);
    }

}
