package cn.wise.im.common.exception.handler;

import cn.wise.im.common.http.R;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.web.servlet.error.ErrorController;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Slf4j
@RestController
@RequestMapping("${server.error.path:/error}")
public class MainsiteErrorController implements ErrorController {

    private final String ERROR_PATH ="/error";

    /**
     * 出现错误，跳转到如下映射中
     * @return
     */
    @Override
    public String getErrorPath() {
        return ERROR_PATH;
    }


    @RequestMapping
    public R handleError(HttpServletRequest request, HttpServletResponse response) {
        int code = response.getStatus();
        if (404 == code) {
            return R.fail(404, "未找到资源");
        } else if (403 == code) {
            return R.fail(403, "没有访问权限");
        } else if (401 == code) {
            return R.fail(401, "登录过期");
        } else {
            return R.fail(500, "服务器错误");
        }
    }

}