package cn.wise.im.common.http;

import lombok.Data;

import java.io.Serializable;

@Data
public class R<T> implements Serializable {
  private Integer code;
 
  private String message;
 
  private T data;
 
  private R() {
  }
 
  public static <T> R<T> ok() {
    return createResult(ResponseEnum.SUCCESS.getCode(), null, null);
  }
 
  public static <T> R<T> ok(T data) {
    return createResult(ResponseEnum.SUCCESS.getCode(), ResponseEnum.SUCCESS.getMessage(), data);
  }
 
  public static <T> R<T> ok(String message) {
    return createResult(ResponseEnum.SUCCESS.getCode(), message, null);
  }
 
  public static <T> R<T> ok(T data, String message) {
    return createResult(ResponseEnum.SUCCESS.getCode(), message, data);
  }
 
  public static <T> R<T> fail() {
    return createResult(ResponseEnum.FAIL.getCode(), ResponseEnum.FAIL.getMessage(), null);
  }
 
  public static <T> R<T> fail(ResponseEnum responseCode) {
    return createResult(responseCode.getCode(), responseCode.getMessage(), null);
  }
 
  public static <T> R<T> fail(ResponseEnum responseCode, T data) {
    return createResult(responseCode.getCode(), responseCode.getMessage(), data);
  }
 
  public static <T> R<T> fail(ResponseEnum responseCode, String message) {
    return createResult(responseCode.getCode(),
        String.format("%s %s", responseCode.getMessage(), message), null);
  }
 
  public static <T> R<T> fail(Integer code, String message) {
    return createResult(code, message, null);
  }
 
  private static <T> R<T> createResult(Integer code, String message, T data) {
    R<T> r = new R<>();
    r.setCode(code);
    r.setMessage(message);
    r.setData(data);
    return r;
  }
}

