package cn.wise.sc.cement.business.controller;

import cn.wise.sc.cement.business.entity.Client;
import cn.wise.sc.cement.business.entity.Project;
import cn.wise.sc.cement.business.model.BaseResponse;
import cn.wise.sc.cement.business.model.PageQuery;
import cn.wise.sc.cement.business.model.PageTableRequest;
import cn.wise.sc.cement.business.model.query.ClientQuery;
import cn.wise.sc.cement.business.model.query.ProjectQuery;
import cn.wise.sc.cement.business.service.IProjectService;
import cn.wise.sc.cement.business.wrapper.WrapMapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;

/**
 * <p>
 *  前端控制器
 * </p>
 *
 * @author ztw
 * @since 2020-08-07
 */
@Api(tags = "配置管理-项目配置")
@RestController
@RequestMapping("/tcdri/project")
public class ProjectController {

	private static final Logger log = LoggerFactory.getLogger("ProjectController");

	@Autowired
	private IProjectService projectService;

	@ApiOperation(value = "项目分页列表")
	@ApiImplicitParams(value = {
			@ApiImplicitParam(name = "code", value = "项目编号", paramType = "query", dataType = "String"),
			@ApiImplicitParam(name = "clientId", value = "客户id", paramType = "query", dataType = "Integer"),
			@ApiImplicitParam(name = "name", value = "项目名称", paramType = "query", dataType = "String"),

	})
	@GetMapping("/getPage")
	public BaseResponse getPage(PageQuery pageQuery, String code, Integer clientId, String name) {
		try {
			return projectService.getPage(pageQuery, code, clientId, name);
		} catch (Exception e) {
			log.debug("项目分页列表{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation("项目导出")
	@PostMapping("/export")
	public void export(String code, Integer clientId, String name, String fileName, HttpServletResponse response) {
		try {
			projectService.export(code, clientId, name, fileName, response);
		} catch (Exception e) {
			log.debug("项目导出{}", e);
		}
	}

	@ApiOperation(value = "项目详情")
	@GetMapping("/{id}")
	public BaseResponse getById(@PathVariable Integer id){
		try {
			Project e = projectService.getById(id);
			if(e == null){
				return BaseResponse.errorMsg("信息错误!");
			}
			return BaseResponse.okData(e);
		}catch (Exception e){
			log.debug("项目详情{}",e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "获取所有启动的项目信息")
	@GetMapping("/getList")
	public BaseResponse getList() {
		try {
			return projectService.getList();
		} catch (Exception e) {
			log.debug("获取所有启动的项目信息{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "新增项目")
	@PostMapping("/create")
	public BaseResponse create(@RequestBody ProjectQuery query){
		try {
			return projectService.create(query);
		}catch (Exception e){
			log.debug("新增项目{}",e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "更新项目")
	@PostMapping("/update")
	public BaseResponse update(@RequestBody ProjectQuery query){
		try {
			return projectService.update(query);
		}catch (Exception e){
			log.debug("更新项目{}",e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "启用禁用")
	@PostMapping("/status")
	public BaseResponse status(Integer status, Integer id){
		try {
			return projectService.status(status, id);
		}catch (Exception e){
			log.debug("启用禁用{}",e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "根据项目名称判断是否存在")
	@GetMapping("/getByName")
	public BaseResponse getByName(String name){
		try {
			return projectService.getByName(name);
		}catch (Exception e){
			log.debug("根据项目名称判断是否存在{}",e);
		}
		return BaseResponse.errorMsg("失败!");
	}


	@ApiOperation(value = "根据委托单位id获取项目列表")
	@GetMapping("/getProjectList")
	public BaseResponse getProjectList(Integer clientId) {
		try {
			return projectService.getProjectList(clientId);
		} catch (Exception e) {
			log.debug("根据委托单位id获取项目列表{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}




}

