package cn.wise.sc.cement.business.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import java.time.LocalDate;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 
 * </p>
 *
 * @author ztw
 * @since 2020-08-24
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Entrust implements Serializable {

    private static final long serialVersionUID=1L;

    /**
     * 主键
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty("委托编号")
    private String entrustCode;

    @ApiModelProperty("项目id")
    private Integer projectId;

    @ApiModelProperty("项目名称")
    private String projectName;

    @ApiModelProperty("项目编号")
    private String projectCode;

    @ApiModelProperty("委托单位id")
    private Integer clientId;

    @ApiModelProperty("送样人")
    private String sendName;

    @ApiModelProperty("送样人电话")
    private String sendPhone;


    @ApiModelProperty("委托日期")
    private LocalDate entrustDate;

	@ApiModelProperty("拟定完成日期")
    private LocalDate finishDate;

    @ApiModelProperty("申请委托人id")
    private Integer userId;

    @ApiModelProperty("样品数量")
    private Integer sampleNum;

    @ApiModelProperty("（1加急，0不加急）")
    private Integer isUrgent;

    @ApiModelProperty("剩余样品处理方法（0,取回，1由本所统一处置）")
    private Integer handleMethod;

    @ApiModelProperty("状态（0未评审，1已通过，2未通过，3样品处理中，4样品处理完成，" +
            "5样品检测中，6样品检测完成，7校核中，8校核完成）")
    private Integer status;

    @ApiModelProperty("项目类型(常规项目，科研项目，质量控制项目)")
    private String projectType;

	@ApiModelProperty("是否发送样品处理（1是，0否）")
	private Integer isHandle;

	@ApiModelProperty("是否派发样品检测（1是，0否）")
	private Integer isDistribution;

    @ApiModelProperty("（0删除，1正常）")
    private Integer isDelete;

    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty("修改时间")
    private LocalDateTime updateTime;

    @ApiModelProperty("备注")
    private String remark;


}
