package cn.wise.sc.cement.business.entity;

import cn.wise.sc.cement.business.model.query.MethodQuery;
import cn.wise.sc.cement.business.model.query.TeamQuery;
import com.baomidou.mybatisplus.annotation.IdType;
import java.time.LocalDate;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;
import java.time.LocalDateTime;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.springframework.beans.BeanUtils;

/**
 * <p>
 * 
 * </p>
 *
 * @author ztw
 * @since 2020-08-18
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Method implements Serializable {

    private static final long serialVersionUID=1L;

	public static Method crate(MethodQuery query) {
		Method newObj = new Method();
		BeanUtils.copyProperties(query, newObj);
		return newObj;
	}

	@TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty("检测依据名")
    private String name;

    @ApiModelProperty("标准号")
    private String standard;

    @ApiModelProperty("编号")
    private String number;

    @ApiModelProperty("实施日期")
    private LocalDate doDate;

    @ApiModelProperty("更新日期")
    private LocalDate upDate;

	@ApiModelProperty("创建时间")
	private LocalDateTime createTime;

	@ApiModelProperty("备注")
	private String remark;







}
