package cn.wise.sc.cement.business.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * <p>
 * 非标产值
 * </p>
 *
 * @author wlb
 * @since 2020-09-22
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName(value = "nonstandard_apply")
public class NonStandardApproval implements Serializable {
	private static final long serialVersionUID = 1L;

	/*
	主键
	 */
	@TableId(value = "id",type = IdType.AUTO)
	private Integer id;

	@ApiModelProperty("工作类别")
	private String workType;

	@ApiModelProperty("起止日期")
	private String statistical;

	@ApiModelProperty("审批工时")
	private Double approvalHours;

	@ApiModelProperty("状态 0：未提交 1：待审批 2：已通过 3：未通过")
	private Integer status;

	@ApiModelProperty("最终产值")
	private Double finalValue;

	@ApiModelProperty("考核公值")
	private Double appraisalValue;

	@ApiModelProperty("驳回意见")
	private String finalRejection;

	@ApiModelProperty("用户id")
	private Integer userId;
}
