package cn.wise.sc.cement.business.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 
 * </p>
 *
 * @author ztw
 * @since 2020-09-23
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class NormProduction implements Serializable {

    private static final long serialVersionUID=1L;

    /**
     * 主键
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 检查组id
     */
    @ApiModelProperty("检查组id")
    private Integer assessId;

    /**
     * 类型  0:检测组  1:处理项
     */
    @ApiModelProperty("类型  0:检测组  1:处理项")
    private Integer type;

    /**
     * 定额工日
     */
    @ApiModelProperty("定额工日")
    private Double quotaDay;

    /**
     * 报出分析结果
     */
    @ApiModelProperty("报出分析结果")
    private Double reportedAnalyseResult;

    /**
     * 建议系数
     */
    @ApiModelProperty("建议系数")
    private Double coefficient;

    /**
     * 考核工值
     */
    @ApiModelProperty("考核工值")
    private Double assessValue;

    /**
     * 分析占比
     */
    @ApiModelProperty("分析占比")
    private Double analyseRate;

    /**
     * 分样占比
     */
    @ApiModelProperty("分样占比")
    private Double separateRate;

    /**
     * 考核占比
     */
    @ApiModelProperty("考核占比")
    private Double assessRate;

    /**
     * 报结果占比
     */
    @ApiModelProperty("报结果占比")
    private Double reportedResultRate;

    /**
     * 状态
     */
    @ApiModelProperty("状态")
    private Integer status;

    /**
     * 标准产值详情
     */
    @Data
    public static class NormProductionDetail{
        private String userName;
        private Integer distributionId;
        private Integer userId;
        private Integer entrustId;
        private Integer assessId;
        private LocalDateTime checkTime;
        private Double analyseRate;
        private Double separateRate;
        private Double assessRate;
        private Double reportedResultRate;
        private String projectName;
        private String sampleName;
        private String entrustCode;
        private Integer sampleId;
        private BigDecimal workTimeCoefficient;
        private Integer type;
        private String groupTeamName;
    }

}
