package cn.wise.sc.cement.business.entity;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.io.Serializable;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 
 * </p>
 *
 * @author ztw
 * @since 2020-08-24
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Sample implements Serializable {

    private static final long serialVersionUID=1L;

    /**
     * 主键
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty("来样编号")
    private String sampleCode;

    @ApiModelProperty("样品名")
    private String name;

    @ApiModelProperty("样品状态（粉、块状)")
    private String sampleForm;

    @ApiModelProperty("检测项id 例子：1、2、3")
    private String teamIds;

    @ApiModelProperty("样品照片")
    private String samplePhoto;

    @ApiModelProperty("样品重量(kg)")
    private BigDecimal weight;

    @ApiModelProperty("(检测依据编号)  例子：01、23、15")
    private String methodNumbers;

    @ApiModelProperty("是否平行样（1是，0否）")
    private Integer isParallel;

    @ApiModelProperty("平行样编号")
    private String parallelCode;

    @ApiModelProperty("本所编号")
    private String cementCode;

    @ApiModelProperty("收费标准")
    private BigDecimal charge;

    @ApiModelProperty("产值")
    private BigDecimal outputValue;

    @ApiModelProperty("委托表id")
    private Integer entrustId;

    @ApiModelProperty("样品临时表id")
    private Integer sampleId;

    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty("备注")
    private String remark;

    //样品管理列表信息
    @ApiModelProperty("样品登记操作人id")
    private Integer operatorId;

    @ApiModelProperty("样品登记时间")
    private LocalDateTime registerTime;

    @ApiModelProperty("处理提醒时间")
    private LocalDate handleDate;

    @ApiModelProperty("小样位置")
    private String littlePosition;

    @ApiModelProperty("原样位置")
    private String originalPosition;

    @ApiModelProperty("（0未领用，1已领用，2已销毁，3复查）")
    private Integer status;

    @ApiModelProperty("销毁时间")
    private LocalDateTime destructionTime;

    @ApiModelProperty("样品处理是否全部完成（0未处理完成，1处理完成")
    private Integer isHandle;

    @ApiModelProperty("样品是否检测完成（0未检测完成， 1检测完成，）")
    private Integer isDistribution;

    @ApiModelProperty("样品是否校核完成（0未检测完成， 1检测完成，）")
    private Integer isCheck;
}
