package cn.wise.sc.cement.business.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;
import java.util.Map;

/**
 * @description: 分页条件查询
 * @author: qh
 * @create: 2019-12-16 15:26
 **/
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class WrapperQuery {

    /**
     * 分页
     */
    private PageQuery pageQuery;

    /**
     * 等于
     */
    private Map<String,Object> eq;

    /**
     * 小于
     */
    private Map<String,Object> lt;

    /**
     * 小于等于
     */
    private Map<String,Object> le;

    /**
     * 大于
     */
    private Map<String,Object> gt;

    /**
     * 大于等于
     */
    private Map<String,Object> ge;

    /**
     * like
     */
    private Map<String,Object> like;

    /**
     * 或者
     */
    private Map<String,Object> or;

    /**
     * sql条件
     */
    private String sql;
    /**
     * in条件
     */
    private Map<String, List<Long>> in;

}
