package cn.wise.sc.cement.business.service;

import cn.wise.sc.cement.business.entity.Equipment;
import cn.wise.sc.cement.business.model.BaseResponse;
import cn.wise.sc.cement.business.model.PageQuery;
import cn.wise.sc.cement.business.model.query.*;
import cn.wise.sc.cement.business.model.vo.*;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;

import javax.servlet.http.HttpServletResponse;

/**
 * <p>
 *  服务类
 * </p>
 *
 * @author ztw
 * @since 2020-09-01
 */
public interface IEquipmentService extends IService<Equipment> {

	BaseResponse<IPage<EquipmentVo>> getPage(PageQuery pageQuery, String brand, Integer supplierId, String name);

	void export(String brand, Integer supplierId, String name, String fileName, HttpServletResponse response);

	void exportTest(String brand, Integer supplierId, String name, String fileName, HttpServletResponse response);

	BaseResponse<Equipment> create(EquipmentQuery query);

	BaseResponse<Equipment> update(EquipmentQuery query);

	BaseResponse<EquipmentVo> getDetail(Integer id);

	BaseResponse<String> test(EquipmentTestQuery query);

	BaseResponse<IPage<EquipmentTestVo>> getTestPage(PageQuery pageQuery, Integer equipmentId);

	BaseResponse<EquipmentTestVo> getTestDetail(Integer id);

	BaseResponse<String> troubleshooting(EquipmentTroubleshootingQuery query);

	BaseResponse<IPage<EquipmentTroubleshootingVo>> getTroubleshootingPage(PageQuery pageQuery, String name);

	void exportTroubleshooting(String name, String fileName, HttpServletResponse response);

	BaseResponse<EquipmentTroubleshootingVo> getTroubleshootingDetail(Integer id);

	BaseResponse<String> scrap(EquipmentScrapQuery query);

	BaseResponse<String> scrapApproval(EquipmentScrapApprovalQuery query);

	BaseResponse<IPage<EquipmentScrapVo>> getScrapApprovalPage(PageQuery pageQuery,
	                                                           String brand, Integer supplierId, String name);

	void exportScrapApproval(String brand, Integer supplierId, String name, String fileName, HttpServletResponse response);

	BaseResponse<EquipmentScrapVo> getscrapApprovalDetail(Integer id);

	BaseResponse<IPage<EquipmentUseVo>> getUsePage(PageQuery pageQuery,
	                                               String brand, Integer supplierId, String name);

	void exportUse(String brand, Integer supplierId, String name, String fileName, HttpServletResponse response);


}
