package cn.wise.sc.cement.business.service.impl;

import cn.hutool.core.util.StrUtil;
import cn.wise.sc.cement.business.entity.Client;
import cn.wise.sc.cement.business.entity.Project;
import cn.wise.sc.cement.business.exception.BusinessExceptionEnum;
import cn.wise.sc.cement.business.mapper.ClientMapper;
import cn.wise.sc.cement.business.mapper.ProjectMapper;
import cn.wise.sc.cement.business.model.BaseResponse;
import cn.wise.sc.cement.business.model.PageQuery;
import cn.wise.sc.cement.business.model.query.ClientQuery;
import cn.wise.sc.cement.business.model.vo.ClientVo;
import cn.wise.sc.cement.business.service.IClientService;
import cn.wise.sc.cement.business.util.ExcelUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import io.swagger.annotations.Api;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author ztw
 * @since 2020-08-07
 */
@Service
public class ClientServiceImpl extends ServiceImpl<ClientMapper, Client> implements IClientService {

	@Resource
	private ClientMapper clientMapper;

    @Override
    public BaseResponse<IPage<ClientVo>> getPage(PageQuery pageQuery, Integer status, String region, String principal) {
	    Map<String, Object> params = new HashMap<>();
	    params.put("status", status);
	    params.put("region", region);
	    params.put("principal", principal);
	    Page<ClientVo> page = new Page<>(pageQuery.getPageNo(), pageQuery.getPageSize());
	    IPage<ClientVo> pages = clientMapper.getPage(page,params);
        return BaseResponse.okData(pages);
    }

    @Override
    public BaseResponse<List<Client>> getList() {
        QueryWrapper<Client> qw = new QueryWrapper<>();
        qw.eq("status", 1);
        List<Client> list = this.list(qw);
        return BaseResponse.okData(list);
    }

    @Override
    @Transactional
    public BaseResponse<Client> create(ClientQuery query) {
        //判断单位名称是否重复
	    QueryWrapper<Client> qw = new QueryWrapper<>();
	    qw.eq("name", query.getName());
	    int count = clientMapper.selectCount(qw);
	    if(count>0){
		    return BaseResponse.errorMsg("单位名称已存在!");
	    }
	    Client create = new Client();
	    BeanUtils.copyProperties(query, create);
	    create.setStatus(1)
			    .setCreateTime(LocalDateTime.now())
			    .setRemark(null);
	    clientMapper.insert(create);
        return BaseResponse.okData(create);
    }

    @Override
    @Transactional
    public BaseResponse<Client> update(ClientQuery query) {
        //判断名字是否重复
	    QueryWrapper<Client> qw = new QueryWrapper<>();
	    qw.eq("name", query.getName());
	    qw.ne("id", query.getId());
	    int count = clientMapper.selectCount(qw);
	    if(count>0){
		    return BaseResponse.errorMsg("单位名称已存在!");
	    }
	    Client update = new Client();
	    BeanUtils.copyProperties(query, update);
	    update.setId(query.getId());
	    clientMapper.updateById(update);
        return BaseResponse.okData(update);
    }

    @Override
    @Transactional
    public BaseResponse<String> status(Integer status, Integer id) {
    	if(status == null || id == null){
		    return BaseResponse.errorMsg("参数错误!");
	    }
		Client client = clientMapper.selectById(id);
		if(client == null){
			return BaseResponse.errorMsg("数据错误!");
		}
	    client.setStatus(status);
		clientMapper.updateById(client);
		String result = "";
		if(client.getStatus() == 1){
			result = "已启用";
		}else{
			result = "已禁用";
		}
        return BaseResponse.okData(result);
    }

	@Override
    public void export(Integer status, String region, String principal, String fileName, HttpServletResponse response){
	    Map<String, Object> params = new HashMap<>();
	    params.put("status", status);
	    params.put("region", region);
	    params.put("principal", principal);
	    List<Map<String, Object>> list= clientMapper.exportList(params);

	    if (!CollectionUtils.isEmpty(list)) {
		    Map<String, Object> map = list.get(0);
		    String[] headers = new String[map.size()];
		    headers[0] = "序号";
		    headers[1] = "单位名称";
		    headers[2] = "联系人";
		    headers[3] = "联系电话";
		    headers[4] = "所在地区";
		    headers[5] = "项目数";
		    headers[6] = "状态";

		    List<Object[]> datas = new ArrayList<>(list.size());
		    for (Map<String, Object> m : list) {
			    Object[] objects = new Object[headers.length];
			    for (int j = 0; j < headers.length; j++) {
				    String obj = m.get(headers[j]).toString();
				    if(j==0){
					    obj = obj.split("\\.")[0];
				    }
				    objects[j] = obj;
			    }

			    datas.add(objects);
		    }
		    ExcelUtil.excelExport(
				    fileName == null || fileName.trim().length() <= 0 ? "委托单位": fileName, headers,
				    datas, response);
	    }
    }




}
