package cn.wise.sc.cement.business.service.impl;

import cn.wise.sc.cement.business.entity.NonStandardApproval;
import cn.wise.sc.cement.business.mapper.NonStandardApprovalMapper;
import cn.wise.sc.cement.business.model.BaseResponse;
import cn.wise.sc.cement.business.model.PageQuery;
import cn.wise.sc.cement.business.model.query.NonStandardApprovalQuery;
import cn.wise.sc.cement.business.model.vo.NonStandardApplyVo;
import cn.wise.sc.cement.business.model.vo.NonStandardApprovalVo;
import cn.wise.sc.cement.business.service.INonStandardApprovalService;
import cn.wise.sc.cement.business.util.ExcelUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author wlb
 * @since 2020-09-17
 */
@Service
public class NonStandardApprovalServiceImpl extends ServiceImpl<NonStandardApprovalMapper, NonStandardApproval> implements INonStandardApprovalService {
	@Resource
	private NonStandardApprovalMapper nonStandardApprovalMapper;

	@Override
	public BaseResponse<IPage<NonStandardApprovalVo>> getPage(PageQuery pageQuery,String name,Integer status) {
		Map<String, Object> params = new HashMap<>();
		params.put("name", name);
		params.put("status",status);
		Page<NonStandardApprovalVo> page = new Page<>(pageQuery.getPageNo(), pageQuery.getPageSize());
		IPage<NonStandardApprovalVo> pages = nonStandardApprovalMapper.getPage(page,params);
		return BaseResponse.okData(pages);
	}

	@Override
	public BaseResponse<List<NonStandardApprovalVo>> getList() {
		QueryWrapper<NonStandardApproval> qw = new QueryWrapper<>();
		qw.gt("status",0);
		List<NonStandardApprovalVo> list = nonStandardApprovalMapper.getList(qw);
		return BaseResponse.okData(list);
	}

	@Override
	public BaseResponse<List<NonStandardApprovalVo>> getById(Integer id) {
		Map<String, Object> params = new HashMap<>();
		params.put("id",id);
		List<NonStandardApprovalVo> list= nonStandardApprovalMapper.getById(params);
		return BaseResponse.okData(list);
	}

	@Override
	public BaseResponse<NonStandardApproval> update(NonStandardApprovalQuery query) {
		if(query.getId() == null){
			return BaseResponse.errorMsg("参数错误");
		}
		NonStandardApproval nonStandardApproval = nonStandardApprovalMapper.selectById(query.getId());
		if(nonStandardApproval == null){
			return BaseResponse.errorMsg("数据错误");
		}
		if(query.getMenuId() == null){
			return BaseResponse.errorMsg("按钮参数不能为空");
		}
		if(query.getMenuId()== 1){   //通过
			nonStandardApproval.setAppraisalValue(query.getAppraisalValue());
			nonStandardApproval.setApprovalHours(query.getApprovalHours());
			//计算最终产值
			Double finalValue = query.getAppraisalValue() * query.getApprovalHours();
			nonStandardApproval.setFinalValue(finalValue);
			nonStandardApproval.setStatus(2);
		}else if(query.getMenuId()== 2){  //拒绝
			nonStandardApproval.setFinalRejection(query.getFinalRejection());
			nonStandardApproval.setStatus(3);
		}else{
			return BaseResponse.errorMsg("按钮参数错误");
		}

		nonStandardApprovalMapper.updateById(nonStandardApproval);
		return BaseResponse.okData(nonStandardApproval);
	}

	@Override
	@Transactional
	public BaseResponse<String> status(Integer status, Integer id) {
		if(status == null || id == null){
			return BaseResponse.errorMsg("参数错误!");
		}
		NonStandardApproval nonStandardApproval = nonStandardApprovalMapper.selectById(id);
		if(nonStandardApproval == null){
			return BaseResponse.errorMsg("数据错误!");
		}
		nonStandardApproval.setStatus(status);
		nonStandardApprovalMapper.updateById(nonStandardApproval);
		String result = "";
		if(nonStandardApproval.getStatus() == 1){
			result = "待审批";
		}else if(nonStandardApproval.getStatus() == 2){
			result = "已通过";
		}else if(nonStandardApproval.getStatus() == 3){
			result = "未通过";
		}else{
			result = "未提交";
		}
		return BaseResponse.okData(result);
	}


	@Override
	public BaseResponse delete(Integer id) {
		NonStandardApproval camd = nonStandardApprovalMapper.selectById(id);
		if(camd == null){
			return BaseResponse.errorMsg("检测依据不存在");
		}
		nonStandardApprovalMapper.deleteById(id);
		return BaseResponse.okData("删除成功");
	}

	@Override
	public void exportList(String filename, String userId, String name, HttpServletResponse response) {
		Map<String, Object> params = new HashMap<>();
		params.put("name", name);
		params.put("userId", userId);
		List<Map<String, Object>> list= nonStandardApprovalMapper.exportList(params);

		if (!CollectionUtils.isEmpty(list)) {
			Map<String, Object> map = list.get(0);
			String[] headers = new String[9];
			headers[0] = "序号";
			headers[1] = "姓名";
			headers[2] = "账户";
			headers[3] = "起止日期";
			headers[4] = "审批工时";
			headers[5] = "状态";
			headers[6] = "最终产值";
			headers[7] = "考核公值";
			headers[8] = "驳回意见";

			List<Object[]> datas = new ArrayList<>(list.size());
			for (Map<String, Object> m : list) {
				Object[] objects = new Object[headers.length];
				for (int j = 0; j < headers.length; j++) {
					String obj = m.get(headers[j])==null?"":m.get(headers[j]).toString();
					if(j==0 && obj!=null){
						obj = obj.split("\\.")[0];
					}
					objects[j] = obj;
				}

				datas.add(objects);
			}
			ExcelUtil.excelExport(
					filename == null || filename.trim().length() <= 0 ? "非标产值审批": filename, headers,
					datas, response);
		}
	}
}
