package cn.wise.sc.cement.business.service.impl;

import cn.wise.sc.cement.business.entity.Supplier;
import cn.wise.sc.cement.business.entity.SysPost;
import cn.wise.sc.cement.business.mapper.SupplierMapper;
import cn.wise.sc.cement.business.model.BaseResponse;
import cn.wise.sc.cement.business.model.PageQuery;
import cn.wise.sc.cement.business.model.query.PostQuery;
import cn.wise.sc.cement.business.model.query.SupplierQuery;
import cn.wise.sc.cement.business.service.ISupplierService;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import jdk.nashorn.internal.ir.annotations.Reference;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.time.LocalDateTime;

/**
 * <p>
 *  服务实现类
 * </p>
 *
 * @author ztw
 * @since 2020-09-01
 */
@Service
public class SupplierServiceImpl extends ServiceImpl<SupplierMapper, Supplier> implements ISupplierService {

	@Resource
	private SupplierMapper supplierMapper;


	/**
	 * 获取分页
	 * @param pageQuery
	 * @param name
	 * @return
	 */
	@Override
	public BaseResponse<IPage<Supplier>> getPage(PageQuery pageQuery, String name) {
		QueryWrapper<Supplier> qw = new QueryWrapper<>();
		if(StringUtils.isNotEmpty(name)){
			qw.like("name", name);
		}
		qw.orderByDesc("create_time");
		IPage<Supplier> page = new Page<>(pageQuery.getPageNo(), pageQuery.getPageSize());
		page = supplierMapper.selectPage(page, qw);
		return BaseResponse.okData(page);
	}


	/**
	 * 新增供应商
	 * @param query
	 * @return
	 */
	@Override
	@Transactional
	public BaseResponse<Supplier> create(SupplierQuery query) {
		if (StringUtils.isEmpty(query.getName())) {
			return BaseResponse.errorMsg("供应商名称不能为空!");
		}
		QueryWrapper<Supplier> qw = new QueryWrapper<>();
		qw.eq("name", query.getName());
		int count = supplierMapper.selectCount(qw);
		if (count > 0) {
			return BaseResponse.errorMsg(query.getName() + "已存在");
		}
		Supplier supplier = new Supplier();
		BeanUtils.copyProperties(query,supplier);
		supplier.setCreateTime(LocalDateTime.now());
		supplierMapper.insert(supplier);
		return BaseResponse.okData(supplier);
	}

	/**
	 * 修改供应商
	 * @param query
	 * @return
	 */
	@Override
	public BaseResponse<Supplier> update(SupplierQuery query) {
		if (StringUtils.isEmpty(query.getName())) {
			return BaseResponse.errorMsg("供应商名称不能为空!");
		}
		QueryWrapper<Supplier> qw = new QueryWrapper<>();
		qw.eq("name", query.getName());
		qw.ne("id", query.getId());
		int count = supplierMapper.selectCount(qw);
		if (count > 0) {
			return BaseResponse.errorMsg(query.getName() + "已存在");
		}
		Supplier supplier = new Supplier();
		BeanUtils.copyProperties(query,supplier);
		supplierMapper.updateById(supplier);
		return BaseResponse.okData(supplier);
	}







}
