package cn.wise.sc.cement.business.util;

import com.sun.org.apache.bcel.internal.generic.RETURN;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.formula.functions.T;
import org.apache.poi.ss.usermodel.*;

import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 校核计算工具类
 * 
 * @author zhutianwei
 *
 */
public class CheckCountUtil {

	//倍数
	public final static BigDecimal param10 = new BigDecimal(10.00);
	public final static BigDecimal param100 = new BigDecimal(100.00);
	public final static BigDecimal param1000 = new BigDecimal(1000.00);
	public final static BigDecimal param10000 = new BigDecimal(10000.00);

	//object 转成  BigDecimal
	public static BigDecimal getBigDecimal(Object value ) {
		BigDecimal ret = null;
		if( value != null ) {
			if( value instanceof BigDecimal ) {
				ret = (BigDecimal) value;
			} else if( value instanceof String ) {
				ret = new BigDecimal( (String) value );
			} else if( value instanceof BigInteger) {
				ret = new BigDecimal( (BigInteger) value );
			} else if( value instanceof Number ) {
				ret = new BigDecimal( ((Number)value).doubleValue() );
			} else {
				throw new ClassCastException("Not possible to coerce ["+value+"] from class "+value.getClass()+" into a BigDecimal.");
			}
		}
		return ret;
	}

	/**
	 * 检测项名称
	 * @param name
	 * @return
	 */
	//加 add 减 subtract  乘 multiply  除 divide
	public static String checkCount(String name, Map<String, Object> resultMap) {
		BigDecimal endResult = null;
		if(name.equals("L.O.I")){
			//样重m1—保留4位⼩数
			BigDecimal m1 = getBigDecimal(resultMap.get("样重m1")).setScale(4,BigDecimal.ROUND_HALF_UP);
			//空堝重m2—保留4位⼩数
			BigDecimal m2 = getBigDecimal(resultMap.get("空堝重m2")).setScale(4,BigDecimal.ROUND_HALF_UP);
			//烧后重m3—保留4位⼩数
			BigDecimal m3 = getBigDecimal(resultMap.get("烧后重m3")).setScale(4,BigDecimal.ROUND_HALF_UP);
			//计算的核心公式结果
			BigDecimal countResult = (m1.add(m2).subtract(m3)).divide(m1,4);
			BigDecimal result1 = countResult.multiply(param100.multiply(param100));
			int resultInt1  = result1.setScale( 0, BigDecimal.ROUND_DOWN ).intValue();
			if((resultInt1&1) == 1){  //如果结果为奇数
				endResult =  countResult.multiply(param100).setScale(2,BigDecimal.ROUND_HALF_UP);
			}else{
				endResult = countResult.multiply(param100).subtract(new BigDecimal(0.0000000001)).setScale(2,BigDecimal.ROUND_HALF_UP);
			}
		}else if(name.equals("SiO2")){
			//毫升数
			BigDecimal VSiO2 = getBigDecimal(resultMap.get("VSiO2"));
			//滴定度
			BigDecimal TSiO2 = getBigDecimal(resultMap.get("TSiO2"));
			//样m
			BigDecimal m = getBigDecimal(resultMap.get("样重m"));
			//计算的核心公式结果
			BigDecimal countResult = VSiO2.multiply(TSiO2).divide(m, 4);
			BigDecimal result1 = countResult.multiply(param100);
			int resultInt1  = result1.setScale( 0, BigDecimal.ROUND_DOWN ).intValue();
			if((resultInt1&1) == 1){  //如果结果为奇数
				endResult =  countResult.setScale(2,BigDecimal.ROUND_HALF_UP);
			}else{
				endResult = countResult.subtract(new BigDecimal(0.0000000001)).setScale(2,BigDecimal.ROUND_HALF_UP);
			}
		}else if(name.equals("Al2O3+TiO2")){
			BigDecimal TAl2O3 = getBigDecimal(resultMap.get("TAl2O3"));
			BigDecimal VAl2O3 = getBigDecimal(resultMap.get("VAl2O3"));
			BigDecimal K = getBigDecimal(resultMap.get("K"));
			BigDecimal VCuSO4_I = getBigDecimal(resultMap.get("VCuSO4(I)"));
			BigDecimal m = getBigDecimal(resultMap.get("样重m"));
			//计算的核心公式结果
			BigDecimal countResult = TAl2O3.multiply(VAl2O3.subtract(K.multiply(VCuSO4_I))).divide(m,4);
			BigDecimal result1 = countResult.multiply(param100);
			int resultInt1  = result1.setScale( 0, BigDecimal.ROUND_DOWN ).intValue();
			if((resultInt1&1) == 1){  //如果结果为奇数
				endResult =  countResult.setScale(2,BigDecimal.ROUND_HALF_UP);
			}else{
				endResult = countResult.subtract(new BigDecimal(0.0000000001)).setScale(2,BigDecimal.ROUND_HALF_UP);
			}
		}else if(name.equals("Al2O3")){
			BigDecimal TAl2O3 = getBigDecimal(resultMap.get("TAl2O3"));
			BigDecimal VAl2O3 = getBigDecimal(resultMap.get("VAl2O3"));
			BigDecimal K = getBigDecimal(resultMap.get("K"));
			BigDecimal VCuSO4_I = getBigDecimal(resultMap.get("VCuSO4(I)"));
			BigDecimal m = getBigDecimal(resultMap.get("样重m"));
			BigDecimal VCuSO4_II = getBigDecimal(resultMap.get("VCuSO4(II)"));
			//计算的核心公式结果
			BigDecimal countResult = TAl2O3.multiply(VAl2O3.subtract(K.multiply(VCuSO4_I.add(VCuSO4_II)))).divide(m,4);
			BigDecimal result1 = countResult.multiply(param100);
			int resultInt1  = result1.setScale( 0, BigDecimal.ROUND_DOWN ).intValue();
			if((resultInt1&1) == 1){  //如果结果为奇数
				endResult =  countResult.setScale(2,BigDecimal.ROUND_HALF_UP);
			}else{
				endResult = countResult.subtract(new BigDecimal(0.0000000001)).setScale(2,BigDecimal.ROUND_HALF_UP);
			}
		}else if(name.equals("Fe2O3")){
			BigDecimal TFe2O3  = getBigDecimal(resultMap.get("TFe2O3"));
			BigDecimal VF2O3  = getBigDecimal(resultMap.get("VF2O3"));
			BigDecimal m = getBigDecimal(resultMap.get("样重m"));
			//计算的核心公式结果
			BigDecimal countResult = TFe2O3.multiply(VF2O3).divide(m,4);
			BigDecimal result1 = countResult.multiply(param100);
			int resultInt1  = result1.setScale( 0, BigDecimal.ROUND_DOWN ).intValue();
			if((resultInt1&1) == 1){  //如果结果为奇数
				endResult =  countResult.setScale(2,BigDecimal.ROUND_HALF_UP);
			}else{
				endResult = countResult.subtract(new BigDecimal(0.0000000001)).setScale(2,BigDecimal.ROUND_HALF_UP);
			}
		}else if(name.equals("CaO")){
			BigDecimal TCaO  = getBigDecimal(resultMap.get("TCaO"));
			BigDecimal VCaO  = getBigDecimal(resultMap.get("VCaO"));
			BigDecimal m = getBigDecimal(resultMap.get("样重m"));
			//计算的核心公式结果
			BigDecimal countResult = TCaO.multiply(VCaO).divide(m,4);
			BigDecimal result1 = countResult.multiply(param100);
			int resultInt1  = result1.setScale( 0, BigDecimal.ROUND_DOWN ).intValue();
			if((resultInt1&1) == 1){  //如果结果为奇数
				endResult =  countResult.setScale(2,BigDecimal.ROUND_HALF_UP);
			}else{
				endResult = countResult.subtract(new BigDecimal(0.00000000001)).setScale(2,BigDecimal.ROUND_HALF_UP);
			}
		}else if(name.equals("MgO")){
			BigDecimal TMgO  = getBigDecimal(resultMap.get("TMgO"));
			BigDecimal VMgO  = getBigDecimal(resultMap.get("VMgO"));
			BigDecimal VCaO  = getBigDecimal(resultMap.get("VCaO"));
			BigDecimal m = getBigDecimal(resultMap.get("样重m"));
			//计算的核心公式结果
			BigDecimal countResult = TMgO.multiply(VMgO.subtract(VCaO)).divide(m,4);
			BigDecimal result1 = countResult.multiply(param100);
			int resultInt1  = result1.setScale( 0, BigDecimal.ROUND_DOWN ).intValue();
			if((resultInt1&1) == 1){  //如果结果为奇数
				endResult =  countResult.setScale(2,BigDecimal.ROUND_HALF_UP);
			}else{
				endResult = countResult.subtract(new BigDecimal(0.0000000001)).setScale(2,BigDecimal.ROUND_HALF_UP);
			}
		}else if(name.equals("TiO2")){
			BigDecimal TTiO2  = getBigDecimal(resultMap.get("TTiO2"));
			BigDecimal VCuSO4_II  = getBigDecimal(resultMap.get("VCuSO4(II)"));
			BigDecimal K  = getBigDecimal(resultMap.get("K"));
			BigDecimal m = getBigDecimal(resultMap.get("样重m"));
			//计算的核心公式结果
			BigDecimal countResult = TTiO2.multiply(VCuSO4_II).multiply(K).divide(m,4);
			BigDecimal result1 = countResult.multiply(param100);
			int resultInt1  = result1.setScale( 0, BigDecimal.ROUND_DOWN ).intValue();
			if((resultInt1&1) == 1){  //如果结果为奇数
				endResult =  countResult.setScale(2,BigDecimal.ROUND_HALF_UP);
			}else{
				endResult = countResult.subtract(new BigDecimal(0.00000000001)).setScale(2,BigDecimal.ROUND_HALF_UP);
			}
		}else if(name.equals("重量法_SO3")){
			BigDecimal m2  = getBigDecimal(resultMap.get("烧重m2"));
			BigDecimal m1  = getBigDecimal(resultMap.get("埚重m1"));
			BigDecimal m3  = getBigDecimal(resultMap.get("空白m3"));
			BigDecimal m = getBigDecimal(resultMap.get("样重m"));
			//计算的核心公式结果
			BigDecimal countResult =  m2.subtract(m1).subtract(m3).divide(m,4).multiply(new BigDecimal(0.343));
			endResult = countResult.multiply(param100).setScale(4,BigDecimal.ROUND_HALF_UP);
		}else if(name.equals("K2O")){
			BigDecimal CK2O  = getBigDecimal(resultMap.get("CK2O"));
			BigDecimal V  = getBigDecimal(resultMap.get("V"));
			BigDecimal AK2O  = getBigDecimal(resultMap.get("AK2O"));
			BigDecimal mR20 = getBigDecimal(resultMap.get("样重R2O"));
			//计算的核心公式结果
			BigDecimal countResult = CK2O.multiply(V).multiply(AK2O).divide(mR20,4).divide(param10000,4);
			BigDecimal result1 = countResult.multiply(param100);
			int resultInt1  = result1.setScale( 0, BigDecimal.ROUND_DOWN ).intValue();
			if((resultInt1&1) == 1){  //如果结果为奇数
				endResult =  countResult.setScale(2,BigDecimal.ROUND_HALF_UP);
			}else{
				endResult = countResult.subtract(new BigDecimal(0.00000000001)).setScale(2,BigDecimal.ROUND_HALF_UP);
			}
		}else if(name.equals("Na2O")){
			BigDecimal CNa2O  = getBigDecimal(resultMap.get("CNa2O"));
			BigDecimal V  = getBigDecimal(resultMap.get("V"));
			BigDecimal ANa2O  = getBigDecimal(resultMap.get("ANa2O"));
			BigDecimal mR20 = getBigDecimal(resultMap.get("样重R2O"));
			//计算的核心公式结果
			BigDecimal countResult = CNa2O.multiply(V).multiply(ANa2O).divide(mR20,4).divide(param10000,4);
			BigDecimal result1 = countResult.multiply(param100);
			int resultInt1  = result1.setScale( 0, BigDecimal.ROUND_DOWN ).intValue();
			if((resultInt1&1) == 1){  //如果结果为奇数
				endResult =  countResult.setScale(2,BigDecimal.ROUND_HALF_UP);
			}else{
				endResult = countResult.subtract(new BigDecimal(0.00000000001)).setScale(2,BigDecimal.ROUND_HALF_UP);
			}
		}else if(name.equals("MnO")){
			BigDecimal CMnO  = getBigDecimal(resultMap.get("CMnO"));
			BigDecimal V  = getBigDecimal(resultMap.get("V"));
			BigDecimal AMnO  = getBigDecimal(resultMap.get("AMnO"));
			BigDecimal mR20 = getBigDecimal(resultMap.get("样重R2O"));
			//计算的核心公式结果
			BigDecimal countResult = CMnO.multiply(V).multiply(AMnO).divide(mR20,4).divide(param10000,4);
			BigDecimal result1 = countResult.multiply(param100);
			int resultInt1  = result1.setScale( 0, BigDecimal.ROUND_DOWN ).intValue();
			if((resultInt1&1) == 1){  //如果结果为奇数
				endResult =  countResult.setScale(2,BigDecimal.ROUND_HALF_UP);
			}else{
				endResult = countResult.subtract(new BigDecimal(0.00000000001)).setScale(2,BigDecimal.ROUND_HALF_UP);
			}
		}else if(name.equals("Cl")){
			BigDecimal T  = getBigDecimal(resultMap.get("T"));
			BigDecimal V2  = getBigDecimal(resultMap.get("V2"));
			BigDecimal V1  = getBigDecimal(resultMap.get("V1"));
			BigDecimal mCl = getBigDecimal(resultMap.get("样重Cl"));
			//计算的核心公式结果
			BigDecimal countResult = T.multiply(V2.subtract(V1)).divide(mCl,4).divide(param10,4);
			BigDecimal result1 = countResult.multiply(param1000);
			int resultInt1  = result1.setScale( 0, BigDecimal.ROUND_DOWN ).intValue();
			if((resultInt1&1) == 1){  //如果结果为奇数
				endResult =  countResult.setScale(3,BigDecimal.ROUND_HALF_UP);
			}else{
				endResult = countResult.subtract(new BigDecimal(0.00000000001)).setScale(3,BigDecimal.ROUND_HALF_UP);
			}
		}else if(name.equals("Mad1")){
			BigDecimal YZ_M1  = getBigDecimal(resultMap.get("样重M1"));
			BigDecimal MZ_M1  = getBigDecimal(resultMap.get("皿重M1"));
			BigDecimal SZ_M1  = getBigDecimal(resultMap.get("烧重M1"));
			//计算的核心公式结果
			BigDecimal countResult = YZ_M1.add(MZ_M1).subtract(SZ_M1).divide(YZ_M1,4);
			endResult = countResult.multiply(param100);
		}else if(name.equals("Mad2")){
			BigDecimal YZ_M2  = getBigDecimal(resultMap.get("样重M2"));
			BigDecimal MZ_M2  = getBigDecimal(resultMap.get("皿重M2"));
			BigDecimal SZ_M2  = getBigDecimal(resultMap.get("烧重M2"));
			//计算的核心公式结果
			BigDecimal countResult = YZ_M2.add(MZ_M2).subtract(SZ_M2).divide(YZ_M2,4);
			endResult = countResult.multiply(param100);
		}else if(name.equals("Aad1")){
			BigDecimal SZ_A1  = getBigDecimal(resultMap.get("烧重A1"));
			BigDecimal MZ_A1  = getBigDecimal(resultMap.get("皿重A1"));
			BigDecimal YZ_A1  = getBigDecimal(resultMap.get("样重A1"));
			//计算的核心公式结果
			BigDecimal countResult = SZ_A1.subtract(MZ_A1).divide(YZ_A1,4);
			endResult = countResult.multiply(param100);
		}else if(name.equals("Aad2")){
			BigDecimal SZ_A2  = getBigDecimal(resultMap.get("烧重A2"));
			BigDecimal MZ_A2  = getBigDecimal(resultMap.get("皿重A2"));
			BigDecimal YZ_A2  = getBigDecimal(resultMap.get("样重A2"));
			//计算的核心公式结果
			BigDecimal countResult = SZ_A2.subtract(MZ_A2).divide(YZ_A2,4);
			endResult = countResult.multiply(param100);
		}else if(name.equals("焦渣")){
			endResult  = getBigDecimal(resultMap.get("焦渣特征"));
		}else if(name.equals("St,ad")){
			endResult  = getBigDecimal(resultMap.get("显示值"));
		}


		return endResult.toString();
	}

	/**
	 * 求SO3
	 * @param resultMap
	 * @param countMap
	 * @return
	 */
	public static String countSO3(Map<String, Object> resultMap, Map<String, String> countMap) {
		BigDecimal weightSO3 = getBigDecimal(countMap.get("重量法_SO3"));
		BigDecimal displaySO3= getBigDecimal(resultMap.get("显示值"));
		BigDecimal mSO3= getBigDecimal(resultMap.get("样重SO3"));
		BigDecimal elseResult = displaySO3.multiply(new BigDecimal(2.5));
		BigDecimal countResult = weightSO3.compareTo(new BigDecimal(0))==1?
				weightSO3:elseResult;
		BigDecimal result1 = countResult.multiply(param1000);
		int resultInt1  = result1.setScale( 0, BigDecimal.ROUND_DOWN ).intValue();
		BigDecimal count = null;
		if((resultInt1&1) == 1){  //如果结果为奇数
			BigDecimal jsResult =  weightSO3.compareTo(new BigDecimal(0))==1?
					weightSO3:elseResult.multiply(mSO3).divide(mSO3,4);
			count =  jsResult.setScale(3,BigDecimal.ROUND_HALF_UP);
		}else{
			BigDecimal osResult =  weightSO3.compareTo(new BigDecimal(0))==1?
					weightSO3:elseResult.multiply(mSO3).divide(mSO3,4);
			count = osResult.subtract(new BigDecimal(0.00000000001)).setScale(3,BigDecimal.ROUND_HALF_UP);
		}
		return count.toString();
	}

	/**
	 *  求合量  L.O.I+SiO2+(Al2O3+TiO2)+Al2O3+Fe2O3+CaO+MgO+TiO2+K2O+Na2O+MnO+SO3
	 * @param countMap
	 * @return
	 */
	public static String countHL(Map<String, String> countMap) {
		List<String> list = new ArrayList<>();
		list.add(countMap.get("L.O.I").toString());
		list.add(countMap.get("SiO2").toString());
//		list.add(countMap.get("Al2O3+TiO2").toString());
		list.add(countMap.get("Al2O3").toString());
		list.add(countMap.get("Fe2O3").toString());
		list.add(countMap.get("CaO").toString());
		list.add(countMap.get("MgO").toString());
		list.add(countMap.get("TiO2").toString());
		list.add(countMap.get("K2O").toString());
		list.add(countMap.get("Na2O").toString());
		list.add(countMap.get("MnO").toString());
		list.add(countMap.get("SO3").toString());
		BigDecimal count=new BigDecimal(0);
		for(String s:list) {
			count = count.add(new BigDecimal(s));
		}
		return count.toString();
	}

	/**
	 * 求KH (CaO - 1.65*{Al2O3+TiO2} * Fe2O3) / 2.8 / SiO2
	 * @param countMap
	 * @return
	 */
	public static String countKH(Map<String, String> countMap) {
		BigDecimal CaO = getBigDecimal(countMap.get("Cao"));
		BigDecimal Al2O3_TiO2= getBigDecimal(countMap.get("Al2O3+TiO2"));
		BigDecimal Fe2O3 = getBigDecimal(countMap.get("Fe2O3"));
		BigDecimal SiO2 = getBigDecimal(countMap.get("SiO2"));
		BigDecimal KH =
		CaO.subtract(new BigDecimal(1.65).multiply(Al2O3_TiO2)).subtract(new BigDecimal(0.35).multiply(Fe2O3)).divide(new BigDecimal(2.8),4).divide(SiO2,4);
		return KH.toString();
	}

	/**
	 * 求SM  SiO2/ ({Al2O3+TiO2} + Fe2O3)
	 * @param countMap
	 * @return
	 */
	public static String countSM(Map<String, String> countMap) {
		BigDecimal SiO2 = getBigDecimal(countMap.get("SiO2"));
		BigDecimal Al2O3_TiO2= getBigDecimal(countMap.get("Al2O3+TiO2"));
		BigDecimal Fe2O3 = getBigDecimal(countMap.get("Fe2O3"));
		BigDecimal SM = SiO2.divide(Al2O3_TiO2.add(Fe2O3),4);
		return SM.toString();
	}

	/**
	 * 求AM  「Al2O3+TiO2」/ Fe2O3
	 * @param countMap
	 * @return
	 */
	public static String countAM(Map<String, String> countMap) {
		BigDecimal Al2O3_TiO2= getBigDecimal(countMap.get("Al2O3+TiO2"));
		BigDecimal Fe2O3 = getBigDecimal(countMap.get("Fe2O3"));
		BigDecimal AM = Al2O3_TiO2.divide(Fe2O3,4);
		return AM.toString();
	}

	/**
	 * 求易烧性等级
	 * @param resultMap 输入集合
	 * @param countMap  输出集合
	 * @return
	 */
	public static String countBurnupLevel(Map<String, Object> resultMap, Map<String, String> countMap) {
		BigDecimal fCaO_1450  = getBigDecimal(resultMap.get("fCaO_1450"));
		BigDecimal KH= getBigDecimal(countMap.get("KH"));
		BigDecimal E = new BigDecimal(45).multiply(KH).subtract(new BigDecimal(37.4));
		BigDecimal D = new BigDecimal(35).multiply(KH).subtract(new BigDecimal(29.3));
		BigDecimal C = new BigDecimal(26.25).multiply(KH).subtract(new BigDecimal(22.15));
		BigDecimal B = new BigDecimal(18.75).multiply(KH).subtract(new BigDecimal(16));
		if(fCaO_1450.compareTo(E) == 1){
			return "E";
		}else if (fCaO_1450.compareTo(D) == 1){
			return "D";
		}else if (fCaO_1450.compareTo(C) == 1){
			return "C";
		}else if (fCaO_1450.compareTo(B) == 1){
			return "B";
		}else{
			return "A";
		}
	}

	/**
	 * 求报出_Mad  （Mad1 + Mad2 ）/ 2
	 * @param countMap
	 * @return
	 */
	public static String countBCMad(Map<String, String> countMap) {
		BigDecimal Mad1= getBigDecimal(countMap.get("Mad1"));
		BigDecimal Mad2= getBigDecimal(countMap.get("Mad2"));
		//计算Mad1 和 Mad2 的平均值
		BigDecimal BC_Mad = Mad1.add(Mad2).divide(new BigDecimal(2),4);
		return  BC_Mad.toString();
	}

	/**
	 * 求Mad  报出_Mad *100 判断奇偶数判断后的结果
	 * @param countMap
	 * @return
	 */
	public static String countMad(Map<String, String> countMap) {
		BigDecimal BC_Mad= getBigDecimal(countMap.get("报出_Mad"));
		//判断奇偶数的最终值
		BigDecimal result1 = BC_Mad.multiply(param100);
		int resultInt1  = result1.setScale( 0, BigDecimal.ROUND_DOWN ).intValue();
		BigDecimal Mad = null;
		if((resultInt1&1) == 1){  //如果结果为奇数
			Mad =  BC_Mad.setScale(2,BigDecimal.ROUND_HALF_UP);
		}else{
			Mad = BC_Mad.subtract(new BigDecimal(0.00000000001)).setScale(2,BigDecimal.ROUND_HALF_UP);
		}
		return  Mad.toString();
	}

	/**
	 * 求报出_Aad  (Aad1 + Aad2)/2
	 * @param countMap
	 * @return
	 */
	public static String countBCAad(Map<String, String> countMap) {
		BigDecimal Aad1= getBigDecimal(countMap.get("Aad1"));
		BigDecimal Aad2= getBigDecimal(countMap.get("Aad2"));
		//计算Mad1 和 Mad2 的平均值
		BigDecimal BC_Aad = Aad1.add(Aad2).divide(new BigDecimal(2),4);
		return  BC_Aad.toString();
	}

	/**
	 * 求Aad  报出_Aad *100 判断奇偶数判断后的结果
	 * @param countMap
	 * @return
	 */
	public static String countAad(Map<String, String> countMap) {
		BigDecimal BC_Aad= getBigDecimal(countMap.get("报出_Aad"));
		//判断奇偶数的最终值
		BigDecimal result1 = BC_Aad.multiply(param100);
		int resultInt1  = result1.setScale( 0, BigDecimal.ROUND_DOWN ).intValue();
		BigDecimal Aad = null;
		if((resultInt1&1) == 1){  //如果结果为奇数
			Aad =  BC_Aad.setScale(2,BigDecimal.ROUND_HALF_UP);
		}else{
			Aad = BC_Aad.subtract(new BigDecimal(0.00000000001)).setScale(2,BigDecimal.ROUND_HALF_UP);
		}
		return  Aad.toString();
	}

	/**
	 * 求Vad1
	 * @param resultMap
	 * @param countMap
	 * @return
	 */
	public static String countVad1(Map<String, Object> resultMap, Map<String, String> countMap) {
		BigDecimal YZ_V1  = getBigDecimal(resultMap.get("样重V1"));
		BigDecimal MZ_V1  = getBigDecimal(resultMap.get("皿重V1"));
		BigDecimal SZ_V1  = getBigDecimal(resultMap.get("烧重V1"));
		BigDecimal BC_Mad  = getBigDecimal(countMap.get("报出_Mad"));
		//计算的核心公式结果
		BigDecimal countResult = YZ_V1.add(MZ_V1).subtract(SZ_V1).divide(YZ_V1,4);
		BigDecimal count = countResult.multiply(param100).subtract(BC_Mad);
		return  count.toString();
	}

	/**
	 * 求Vad2
	 * @param resultMap
	 * @param countMap
	 * @return
	 */
	public static String countVad2(Map<String, Object> resultMap, Map<String, String> countMap) {
		BigDecimal YZ_V2  = getBigDecimal(resultMap.get("样重V2"));
		BigDecimal MZ_V2  = getBigDecimal(resultMap.get("皿重V2"));
		BigDecimal SZ_V2  = getBigDecimal(resultMap.get("烧重V2"));
		BigDecimal BC_Mad  = getBigDecimal(countMap.get("报出_Mad"));
		//计算的核心公式结果
		BigDecimal countResult = YZ_V2.add(MZ_V2).subtract(SZ_V2).divide(YZ_V2,4);
		BigDecimal count = countResult.multiply(param100).subtract(BC_Mad);
		return  count.toString();
	}

	/**
	 * 求报出_Vad  (Vad1+ Vad2)/2
	 * @param countMap
	 * @return
	 */
	public static String countBCVad(Map<String, String> countMap) {
		BigDecimal Vad1= getBigDecimal(countMap.get("Vad1"));
		BigDecimal Vad2= getBigDecimal(countMap.get("Vad2"));
		//计算Vad1 和 Vad2 的平均值
		BigDecimal BC_Vad = Vad1.add(Vad2).divide(new BigDecimal(2),4);
		return  BC_Vad.toString();
	}

	/**
	 * 求Vad  报出_Vad *100 判断奇偶数判断后的结果
	 * @param countMap
	 * @return
	 */
	public static String countVad(Map<String, String> countMap) {
		BigDecimal BC_Vad= getBigDecimal(countMap.get("报出_Vad"));
		//判断奇偶数的最终值
		BigDecimal result1 = BC_Vad.multiply(param100);
		int resultInt1  = result1.setScale( 0, BigDecimal.ROUND_DOWN ).intValue();
		BigDecimal Vad = null;
		if((resultInt1&1) == 1){  //如果结果为奇数
			Vad =  BC_Vad.setScale(2,BigDecimal.ROUND_HALF_UP);
		}else{
			Vad = BC_Vad.subtract(new BigDecimal(0.00000000001)).setScale(2,BigDecimal.ROUND_HALF_UP);
		}
		return  Vad.toString();
	}

	/**
	 * 求Vdaf  Vad *100/(100-Mad-Aad)
	 * @param countMap
	 * @return
	 */
	public static String countVdaf(Map<String, String> countMap) {
		BigDecimal Vad= getBigDecimal(countMap.get("Vad"));
		BigDecimal Mad= getBigDecimal(countMap.get("Mad"));
		BigDecimal Aad= getBigDecimal(countMap.get("Aad"));
		BigDecimal Vdaf = Vad.multiply(param100).multiply(param100.subtract(Mad).subtract(Aad));
		return  Vdaf.toString();
	}

	/**
	 * 求Vdaf  Vad *100/(100-Mad-Aad)
	 * @param countMap
	 * @return
	 */
	public static String countK1_(Map<String, String> countMap) {
		BigDecimal Vdaf= getBigDecimal(countMap.get("Vdaf"));
		BigDecimal K1_=
		Vdaf.compareTo(new BigDecimal(62))==1?new BigDecimal(61.5):(
				Vdaf.compareTo(new BigDecimal(56))==1?new BigDecimal(63):(
				Vdaf.compareTo(new BigDecimal(49))==1?new BigDecimal(65):(
				Vdaf.compareTo(new BigDecimal(45))==1?new BigDecimal(67):(
				Vdaf.compareTo(new BigDecimal(37))==1?new BigDecimal(68.5):
				new BigDecimal(0)
				))));
		return  K1_.toString();
	}

	/**
	 * 求K  if 焦渣特征=1 JZB1  if 焦渣特征=1.5 JZB1_5 f 焦渣特征=2 JZB2
	 * @param resultMap
	 * @param countMap
	 * @return
	 */
	public static String countK(Map<String, Object> resultMap, Map<String, String> countMap) {
		String JZTZ= resultMap.get("焦渣特征").toString();
		BigDecimal Vdaf= getBigDecimal(countMap.get("Vdaf"));
		//获取焦渣特征序号对应的值
		Map<String, String>  map = JZTZCountUtil.getJZTZ(Vdaf);
		String count = "";
		if(JZTZ.equals("1")){
			count = map.get(JZTZ);
		}else if(JZTZ.equals("1.5")){
			count = map.get(JZTZ);
		}else if(JZTZ.equals("2")){
			count = map.get(JZTZ);
		}else if(JZTZ.equals("2.5")){
			count = map.get(JZTZ);
		}else if(JZTZ.equals("3")){
			count = map.get(JZTZ);
		}else if(JZTZ.equals("3.5")){
			count = map.get(JZTZ);
		}else if(JZTZ.equals("4")){
			count = map.get(JZTZ);
		}else if(JZTZ.equals("4.5")){
			count = map.get(JZTZ);
		}else if(JZTZ.equals("5")){
			count = map.get(JZTZ);
		}else if(JZTZ.equals("5.5")){
			count = map.get(JZTZ);
		}else if(JZTZ.equals("6")){
			count = map.get(JZTZ);
		}else if(JZTZ.equals("6.5")){
			count = map.get(JZTZ);
		}else if(JZTZ.equals("7")){
			count = map.get(JZTZ);
		}else if(JZTZ.equals("7.5")){
			count = map.get(JZTZ);
		}else if(JZTZ.equals("8")){
			count = map.get(JZTZ);
		}else{
			count = "false";
		}

		return  count;
	}

	/**
	 * 求Vdaf判断  Vdaf<35?1:0
	 * @param countMap
	 * @return
	 */
	public static String countVdafPD(Map<String, String> countMap) {
		BigDecimal Vdaf= getBigDecimal(countMap.get("Vdaf"));
		Integer VdafPD = Vdaf.compareTo(new BigDecimal(35))==-1?1:0;
		return  VdafPD.toString();
	}

	/**
	 * 求Mad判断  Mad>3?1:0
	 * @param countMap
	 * @return
	 */
	public static String countMadPD(Map<String, String> countMap) {
		BigDecimal BC_Mad= getBigDecimal(countMap.get("报出_Mad"));
		Integer MadPD = BC_Mad.compareTo(new BigDecimal(3))==1?1:0;
		return  MadPD.toString();
	}

	/**
	 * 求40Mad 0或1     Vdaf判断* Mad判断
	 * @param countMap
	 * @return
	 */
	public static String count40Mad0Or1(Map<String, String> countMap) {
		BigDecimal VdafPD= getBigDecimal(countMap.get("Vdaf判断"));
		BigDecimal MadPD= getBigDecimal(countMap.get("Mad判断"));
		BigDecimal count = VdafPD.multiply(MadPD);
		return  count.toString();
	}

	/**
	 * 求40Mad 0或1
	 * @param countMap
	 * @return
	 */
	public static String countAd(Map<String, String> countMap) {
		BigDecimal BC_Aad= getBigDecimal(countMap.get("报出_Aad"));
		BigDecimal BC_Mad= getBigDecimal(countMap.get("报出_Mad"));
		BigDecimal count = BC_Aad.multiply(param100).divide(param100.subtract(BC_Mad),4);
		return  count.toString();
	}

	/**
	 * 求Ad系数0.1或0   if Ad>20 0.1 else 0
	 * @param countMap
	 * @return
	 */
	public static String countAdXS(Map<String, String> countMap) {
		BigDecimal Ad= getBigDecimal(countMap.get("Ad"));
		BigDecimal count =
		Ad.compareTo(new BigDecimal(20))==1?new BigDecimal(0.1):new BigDecimal(0);
		return  count.toString();
	}

	public static String countVdafXS(Map<String, String> countMap) {
		BigDecimal Ad= getBigDecimal(countMap.get("Ad"));
		Double count =
				Ad.compareTo(new BigDecimal(30))==1?0.8:(
				Ad.compareTo(new BigDecimal(25))==1?0.85:(
				Ad.compareTo(new BigDecimal(20))==1?0.95:(
				Ad.compareTo(new BigDecimal(15))==1?0.8:(
				Ad.compareTo(new BigDecimal(10))==1?0.9:
				0.95
				))));
		return  count.toString();
	}

	/**
	 * 求V，daf  [Vdaf系数0.8~0.95]* Vdaf- [Ad系数0.1或0]*Ad
	 * @param countMap
	 * @return
	 */
	public static String countV_daf(Map<String, String> countMap) {
		BigDecimal VdafXS= getBigDecimal(countMap.get("Vdaf系数0.8~0.95"));
		BigDecimal Vdaf= getBigDecimal(countMap.get("Vdaf"));
		BigDecimal AdXS= getBigDecimal(countMap.get("Ad系数0.1或0"));
		BigDecimal Ad= getBigDecimal(countMap.get("Ad"));
		BigDecimal count = VdafXS.multiply(Vdaf).subtract(AdXS.multiply(Ad));
		return  count.toString();
	}

	/**
	 * 求K0，  if V，daf >8 8500 if V，daf >5.5 8400 if V，daf >3 8300  else 8200
	 * @param countMap
	 * @return
	 */
	public static String countK0_(Map<String, String> countMap) {
		BigDecimal V_daf= getBigDecimal(countMap.get("V,daf"));
		BigDecimal count =
				V_daf.compareTo(new BigDecimal(8))==1?new BigDecimal(8500):(
				V_daf.compareTo(new BigDecimal(5.5))==1?new BigDecimal(8400):(
				V_daf.compareTo(new BigDecimal(3))==1?new BigDecimal(8300):
				new BigDecimal(8200)
				));
		return  count.toString();
	}

	/**
	 * 求Qnet,ad MJ/kg
	 * @param countMap
	 * @return
	 */
	public static String countQnet_adMJ_kg(Map<String, Object> resultMap, Map<String, String> countMap) {
		BigDecimal YWH_123= getBigDecimal(resultMap.get("烟无褐123"));
		BigDecimal K1_= getBigDecimal(countMap.get("K1,"));
		BigDecimal BC_Mad= getBigDecimal(countMap.get("报出_Mad"));
		BigDecimal BC_Aad= getBigDecimal(countMap.get("报出_Aad"));
		BigDecimal BC_Vad= getBigDecimal(countMap.get("报出_Vad"));
		BigDecimal K= getBigDecimal(countMap.get("K"));
		BigDecimal _40Mad_0_1= getBigDecimal(countMap.get("40Mad 0或1"));
		BigDecimal K0_= getBigDecimal(countMap.get("K0,"));
		BigDecimal value = null;
		if(YWH_123.compareTo(new BigDecimal(3))==0){
			value =param100.multiply(K1_).subtract(K1_.add(new BigDecimal(6)).multiply(BC_Mad.add(BC_Aad)))
					.subtract(BC_Vad);
		} else if(YWH_123.compareTo(new BigDecimal(1))==0){
			value =param100.multiply(K).subtract(K.add(new BigDecimal(6)).multiply(BC_Mad.add(BC_Aad)))
					.subtract(new BigDecimal(3).multiply(BC_Vad))
					.subtract(new BigDecimal(40).multiply(BC_Mad).multiply(_40Mad_0_1));
		}else if(YWH_123.compareTo(new BigDecimal(2))==0){
			value =K0_.subtract(new BigDecimal(86).multiply(BC_Mad))
					.subtract(new BigDecimal(92).multiply(BC_Aad))
					.subtract(new BigDecimal(24).multiply(BC_Vad));
		}
		BigDecimal count = value.multiply(new BigDecimal(4.1816)).divide(param1000,4);
		return  count.toString();
	}

	/**
	 * 求易磨性等级
	 * @param resultMap
	 * @return
	 */
	public static String countYMXGrade(Map<String, Object> resultMap) {
		BigDecimal YMX_kWh_t  = getBigDecimal(resultMap.get("易磨性(kWh/t)"));
		if(YMX_kWh_t.compareTo(new BigDecimal(18))==1){
			return "E";
		}else if(YMX_kWh_t.compareTo(new BigDecimal(13))==1){
			return "D";
		}else if(YMX_kWh_t.compareTo(new BigDecimal(10))==1){
			return "C";
		}else if(YMX_kWh_t.compareTo(new BigDecimal(8))==1){
			return "B";
		}else{
			return "A";
		}
	}

	/**
	 * 求易磨性校验码
	 * @param resultMap
	 * @return
	 */
	public static String countYMXCode(Map<String, Object> resultMap) {
		Double G  = Double.valueOf(resultMap.get("G").toString());
		Double P80  = Double.valueOf(resultMap.get("P80").toString());
		Double F80  = Double.valueOf(resultMap.get("F80").toString());
		BigDecimal YMX_kWh_t  = getBigDecimal(resultMap.get("易磨性(kWh/t)"));
		BigDecimal YMX_MJ_t  = getBigDecimal(resultMap.get("易磨性(MJ/t)"));
		Double countResult =
		Math.pow(80,0.23)*Math.pow(G,0.82)*(10/(Math.pow(P80,0.5)- 10/Math.pow(F80,0.5)));
		BigDecimal result1 = new BigDecimal(countResult);
		BigDecimal value1 =
		new BigDecimal(176.2).divide(result1,4).subtract(new BigDecimal(3.6).multiply(new BigDecimal(P80))).abs();
		BigDecimal value2 = YMX_MJ_t.divide(YMX_kWh_t,4);
		if(value1.compareTo(new BigDecimal(0.5) ) == -1 &&
				value2.compareTo(new BigDecimal(3.5)) == 1 &&
				value2.compareTo(new BigDecimal(3.7)) == -1){
			return "OK";
		}else{
			return "出错了";
		}
	}

	/**
	 * 计算平行数
	 * @param mainResult  主样数据
	 * @param secondaryResult 次样数据
	 * @return
	 */
	public static String countParallel(String mainResult, String secondaryResult) {
		BigDecimal main = getBigDecimal(mainResult);
		BigDecimal secondary = getBigDecimal(secondaryResult);
		BigDecimal aveCount = main.add(secondary).divide(new BigDecimal(2),2);
		BigDecimal result1 = aveCount.multiply(param100);
		int resultInt1  = result1.setScale( 0, BigDecimal.ROUND_DOWN ).intValue();
		BigDecimal endResult = null;
		if((resultInt1&1) == 1){  //如果结果为奇数
			endResult =  aveCount.multiply(param100).setScale(2,BigDecimal.ROUND_HALF_UP);
		}else{
			endResult = aveCount.multiply(param100).subtract(new BigDecimal(0.0000000001)).setScale(2,BigDecimal.ROUND_HALF_UP);
		}
		return  endResult.toString();
	}











}












