package cn.wise.sc.cement.business.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 焦渣特征序号值计算工具类
 * 
 * @author zhutianwei
 *
 */
public class JZTZCountUtil {

	public static  final  BigDecimal NO42 = new BigDecimal(42);
	public static  final  BigDecimal NO38 = new BigDecimal(42);
	public static  final  BigDecimal NO35 = new BigDecimal(42);
	public static  final  BigDecimal NO32 = new BigDecimal(42);
	public static  final  BigDecimal NO29 = new BigDecimal(42);
	public static  final  BigDecimal NO23 = new BigDecimal(42);
	public static  final  BigDecimal NO20 = new BigDecimal(42);
	public static  final  BigDecimal NO17 = new BigDecimal(42);
	public static  final  BigDecimal NO13_5 = new BigDecimal(42);
	public static  final  BigDecimal NO10 = new BigDecimal(42);





	/**
	 * 根据Vdaf获取焦渣特征编号对应值
	 * @param Vdaf
	 * @return
	 */
	public static Map<String, String> getJZTZ(BigDecimal Vdaf){
		Map<String, String> map = new HashMap<>();
		String JZTZ1 =
				Vdaf.compareTo(NO42)==1?"72.5":(
				Vdaf.compareTo(NO38)==1?"73":(
				Vdaf.compareTo(NO35)==1?"73":(
				Vdaf.compareTo(NO32)==1?"73":(
				Vdaf.compareTo(NO29)==1?"76.5":(
				Vdaf.compareTo(NO23)==1?"76.5":(
				Vdaf.compareTo(NO20)==1?"78.5":(
				Vdaf.compareTo(NO17)==1?"80":(
				Vdaf.compareTo(NO13_5)==1?"80.5":(
				Vdaf.compareTo(NO10)==1?"84":"false")))))))));
		String JZTZ1_5 =
				Vdaf.compareTo(NO42)==1?"73.5":(
				Vdaf.compareTo(NO38)==1?"74.25":(
				Vdaf.compareTo(NO35)==1?"74.75":(
				Vdaf.compareTo(NO32)==1?"75.25":(
				Vdaf.compareTo(NO29)==1?"77.25":(
				Vdaf.compareTo(NO23)==1?"77.5":(
				Vdaf.compareTo(NO20)==1?"79.75":(
				Vdaf.compareTo(NO17)==1?"81":(
				Vdaf.compareTo(NO13_5)==1?"82":(
				Vdaf.compareTo(NO10)==1?"84":"false")))))))));
		String JZTZ2 =
				Vdaf.compareTo(NO42)==1?"74.5":(
				Vdaf.compareTo(NO38)==1?"75.5":(
				Vdaf.compareTo(NO35)==1?"76.5":(
				Vdaf.compareTo(NO32)==1?"77.5":(
				Vdaf.compareTo(NO29)==1?"78":(
				Vdaf.compareTo(NO23)==1?"78.5":(
				Vdaf.compareTo(NO20)==1?"81":(
				Vdaf.compareTo(NO17)==1?"82.75":(
				Vdaf.compareTo(NO13_5)==1?"83.5":(
				Vdaf.compareTo(NO10)==1?"84":"false")))))))));
		String JZTZ2_5 =
				Vdaf.compareTo(NO42)==1?"75.5":(
				Vdaf.compareTo(NO38)==1?"76.75":(
				Vdaf.compareTo(NO35)==1?"77.5":(
				Vdaf.compareTo(NO32)==1?"78.25":(
				Vdaf.compareTo(NO29)==1?"79":(
				Vdaf.compareTo(NO23)==1?"79.75":(
				Vdaf.compareTo(NO20)==1?"81.75":(
				Vdaf.compareTo(NO17)==1?"82.75":(
				Vdaf.compareTo(NO13_5)==1?"84":(
				Vdaf.compareTo(NO10)==1?"84.25":"false")))))))));
		String JZTZ3  =
				Vdaf.compareTo(NO42)==1?"76.5":(
				Vdaf.compareTo(NO38)==1?"78":(
				Vdaf.compareTo(NO35)==1?"78.5":(
				Vdaf.compareTo(NO32)==1?"79":(
				Vdaf.compareTo(NO29)==1?"80":(
				Vdaf.compareTo(NO23)==1?"81":(
				Vdaf.compareTo(NO20)==1?"82.5":(
				Vdaf.compareTo(NO17)==1?"83.5":(
				Vdaf.compareTo(NO13_5)==1?"84.5":(
				Vdaf.compareTo(NO10)==1?"84.5":"false"	)))))))));
		String JZTZ3_5  =
				Vdaf.compareTo(NO42)==1?"77":(
				Vdaf.compareTo(NO38)==1?"78.5":(
				Vdaf.compareTo(NO35)==1?"79":(
				Vdaf.compareTo(NO32)==1?"79.5":(
				Vdaf.compareTo(NO29)==1?"80.5":(
				Vdaf.compareTo(NO23)==1?"81.5":(
				Vdaf.compareTo(NO20)==1?"82.75":(
				Vdaf.compareTo(NO17)==1?"83.75":(
				Vdaf.compareTo(NO13_5)==1?"84.75":(
				Vdaf.compareTo(NO10)==1?"84.5":"false"	)))))))));
		String JZTZ4  =
				Vdaf.compareTo(NO42)==1?"77.5":(
				Vdaf.compareTo(NO38)==1?"79":(
				Vdaf.compareTo(NO35)==1?"79.5":(
				Vdaf.compareTo(NO32)==1?"80":(
				Vdaf.compareTo(NO29)==1?"81":(
				Vdaf.compareTo(NO23)==1?"82":(
				Vdaf.compareTo(NO20)==1?"83":(
				Vdaf.compareTo(NO17)==1?"84":(
				Vdaf.compareTo(NO13_5)==1?"85":(
				Vdaf.compareTo(NO10)==1?"84.5":"false"	)))))))));
		String JZTZ4_5  =
				Vdaf.compareTo(NO42)==1?"78.5":(
				Vdaf.compareTo(NO38)==1?"79.5":(
				Vdaf.compareTo(NO35)==1?"80.25":(
				Vdaf.compareTo(NO32)==1?"80.75":(
				Vdaf.compareTo(NO29)==1?"81.75":(
				Vdaf.compareTo(NO23)==1?"82.75":(
				Vdaf.compareTo(NO20)==1?"83.5":(
				Vdaf.compareTo(NO17)==1?"84.5":(
				Vdaf.compareTo(NO13_5)==1?"85":(
				Vdaf.compareTo(NO10)==1?"84.5":"false"	)))))))));
		String JZTZ5  =
				Vdaf.compareTo(NO42)==1?"79.5":(
				Vdaf.compareTo(NO38)==1?"80":(
				Vdaf.compareTo(NO35)==1?"81":(
				Vdaf.compareTo(NO32)==1?"81.5":(
				Vdaf.compareTo(NO29)==1?"82.5":(
				Vdaf.compareTo(NO23)==1?"83.5":(
				Vdaf.compareTo(NO20)==1?"84":(
				Vdaf.compareTo(NO17)==1?"85":(
				Vdaf.compareTo(NO13_5)==1?"85":(
				Vdaf.compareTo(NO10)==1?"84.5":"false"	)))))))));
		String JZTZ5_5  =
				Vdaf.compareTo(NO42)==1?"79.5":(
				Vdaf.compareTo(NO38)==1?"80":(
				Vdaf.compareTo(NO35)==1?"81":(
				Vdaf.compareTo(NO32)==1?"81.5":(
				Vdaf.compareTo(NO29)==1?"82.5":(
				Vdaf.compareTo(NO23)==1?"83.5":(
				Vdaf.compareTo(NO20)==1?"84":(
				Vdaf.compareTo(NO17)==1?"85":(
				Vdaf.compareTo(NO13_5)==1?"85":(
				Vdaf.compareTo(NO10)==1?"84.5":"false"	)))))))));
		String JZTZ6  =
				Vdaf.compareTo(NO42)==1?"79.5":(
				Vdaf.compareTo(NO38)==1?"80":(
				Vdaf.compareTo(NO35)==1?"81":(
				Vdaf.compareTo(NO32)==1?"81.5":(
				Vdaf.compareTo(NO29)==1?"82.5":(
				Vdaf.compareTo(NO23)==1?"83.5":(
				Vdaf.compareTo(NO20)==1?"84":(
				Vdaf.compareTo(NO17)==1?"85":(
				Vdaf.compareTo(NO13_5)==1?"85":(
				Vdaf.compareTo(NO10)==1?"84.5":"false"	)))))))));
		String JZTZ6_5  =
				Vdaf.compareTo(NO42)==1?"80.25":(
				Vdaf.compareTo(NO38)==1?"81":(
				Vdaf.compareTo(NO35)==1?"81.75":(
				Vdaf.compareTo(NO32)==1?"82.25":(
				Vdaf.compareTo(NO29)==1?"83.25":(
				Vdaf.compareTo(NO23)==1?"84":(
				Vdaf.compareTo(NO20)==1?"84.5":(
				Vdaf.compareTo(NO17)==1?"85":(
				Vdaf.compareTo(NO13_5)==1?"85":(
				Vdaf.compareTo(NO10)==1?"84.5":"false"	)))))))));
		String JZTZ7  =
				Vdaf.compareTo(NO42)==1?"81":(
				Vdaf.compareTo(NO38)==1?"82":(
				Vdaf.compareTo(NO35)==1?"82.5":(
				Vdaf.compareTo(NO32)==1?"83":(
				Vdaf.compareTo(NO29)==1?"84":(
				Vdaf.compareTo(NO23)==1?"84.5":(
				Vdaf.compareTo(NO20)==1?"85":(
				Vdaf.compareTo(NO17)==1?"85":(
				Vdaf.compareTo(NO13_5)==1?"85":(
				Vdaf.compareTo(NO10)==1?"84.5":"false"	)))))))));
		String JZTZ7_5  =
				Vdaf.compareTo(NO42)==1?"81.5":(
				Vdaf.compareTo(NO38)==1?"82.25":(
				Vdaf.compareTo(NO35)==1?"82.75":(
				Vdaf.compareTo(NO32)==1?"83":(
				Vdaf.compareTo(NO29)==1?"84.25":(
				Vdaf.compareTo(NO23)==1?"84.75":(
				Vdaf.compareTo(NO20)==1?"85.25":(
				Vdaf.compareTo(NO17)==1?"85":(
				Vdaf.compareTo(NO13_5)==1?"85":(
				Vdaf.compareTo(NO10)==1?"84.5":"false"	)))))))));
		String JZTZ8  =
				Vdaf.compareTo(NO42)==1?"82":(
				Vdaf.compareTo(NO38)==1?"82.5":(
				Vdaf.compareTo(NO35)==1?"83":(
				Vdaf.compareTo(NO32)==1?"83.5":(
				Vdaf.compareTo(NO29)==1?"84.5":(
				Vdaf.compareTo(NO23)==1?"85":(
				Vdaf.compareTo(NO20)==1?"85.5":(
				Vdaf.compareTo(NO17)==1?"85":(
				Vdaf.compareTo(NO13_5)==1?"85":(
				Vdaf.compareTo(NO10)==1?"84.5":"false"	)))))))));
		map.put("1",JZTZ1);
		map.put("1.5",JZTZ1_5);
		map.put("2",JZTZ2);
		map.put("2.5",JZTZ2_5);
		map.put("3",JZTZ3);
		map.put("3.5",JZTZ3_5);
		map.put("4",JZTZ4);
		map.put("4.5",JZTZ4_5);
		map.put("5",JZTZ5);
		map.put("5.5",JZTZ5_5);
		map.put("6",JZTZ6);
		map.put("6.5",JZTZ6_5);
		map.put("7",JZTZ7);
		map.put("7.5",JZTZ7_5);
		map.put("8",JZTZ8);
		return  map;
	}





}












