package cn.wise.sc.cement.business.controller;

import cn.wise.sc.cement.business.entity.NonStandardApply;
import cn.wise.sc.cement.business.model.BaseResponse;
import cn.wise.sc.cement.business.model.PageQuery;
import cn.wise.sc.cement.business.model.query.NonStandardApplyQuery;
import cn.wise.sc.cement.business.model.vo.NonStandardApplyVo;
import cn.wise.sc.cement.business.service.INonStandardApplyService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * <p>
 * 前端控制器
 * </p>
 *
 * @author wlb
 * @since 2020-09-23
 */
@Api(tags = "非标产值-非标产值申请")
@RestController
@RequestMapping("/tcdri/nonstandard_apply")
public class NonStandardApplyController {
	private static final Logger log = LoggerFactory.getLogger("NonStandardApplyController");

	@Autowired
	private INonStandardApplyService iNonStandardApplyService;

	@ApiOperation(value = "非标产值申请分页")
	@GetMapping("/getPage")
	public BaseResponse getPage(PageQuery pageQuery, String name,Integer userId) {
		try {
			return iNonStandardApplyService.getPage(pageQuery, name,userId);
		} catch (Exception e) {
			log.debug("非标产值申请分页列表{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "根据id查询指定非标产值申请信息")
	@GetMapping("/{id}")
	public BaseResponse getById(@PathVariable Integer id) {
		try {
			BaseResponse<List<NonStandardApplyVo>> e = iNonStandardApplyService.getById(id);
			if (e == null) {
				return BaseResponse.errorMsg("信息错误!");
			}
			return BaseResponse.okData(e);
		} catch (Exception e) {
			log.debug("通过id查询非标产值申请信息{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "获取当前用户所有的非标产值申请")
	@GetMapping("/getList")
	public BaseResponse getList(Integer userId) {
		try {
			return iNonStandardApplyService.getList(userId);
		} catch (Exception e) {
			log.debug("获取所有的非标产值申请{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "提交申请")
	@PostMapping("/create")
	public BaseResponse create(@RequestBody NonStandardApplyQuery query) {
		try {
			return iNonStandardApplyService.create(query);
		} catch (Exception e) {
			log.debug("提交申请{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "修改非标产值信息")
	@PostMapping("/update")
	public BaseResponse update(@RequestBody NonStandardApplyQuery nonStandardApplyQuery) {
		try {
			return iNonStandardApplyService.update(nonStandardApplyQuery);
		} catch (Exception e) {
			log.debug("修改非标产值信息{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "提交操作按钮实现")
	@PostMapping("/status")
	public BaseResponse status(Integer status, Integer id) {
		try {
			return iNonStandardApplyService.status(status, id);
		} catch (Exception e) {
			log.debug("提交操作实现{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "删除非标产值申请")
	@PostMapping("/delete/{id}")
	public BaseResponse delete(@PathVariable Integer id) {
		try {
			return iNonStandardApplyService.delete(id);
		} catch (Exception e) {
			log.debug("删除非标产值申请{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation("非标产值申请导出列表")
	@PostMapping("/exportList")
	public void exportList(String filename, Integer userId, String name, HttpServletResponse response) {
		try {
			iNonStandardApplyService.exportList(filename, userId, name, response);
		} catch (Exception e) {
			log.debug("非标产值申请导出列表{}", e);
		}
	}
}
