package cn.wise.sc.cement.business.controller;

import cn.wise.sc.cement.business.entity.Supplier;
import cn.wise.sc.cement.business.entity.SysPost;
import cn.wise.sc.cement.business.model.BaseResponse;
import cn.wise.sc.cement.business.model.PageQuery;
import cn.wise.sc.cement.business.model.query.PostQuery;
import cn.wise.sc.cement.business.model.query.SupplierQuery;
import cn.wise.sc.cement.business.service.ISupplierService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 前端控制器
 * </p>
 *
 * @author ztw
 * @since 2020-09-01
 */
@Api(tags = "资源管理-供应商管理")
@RestController
@RequestMapping("/business/supplier")
public class SupplierController {

	private static final Logger log = LoggerFactory.getLogger("SupplierController");

	@Autowired
	private ISupplierService supplierService;

	@ApiOperation(value = "供应商分页列表")
	@ApiImplicitParams(value = {
			@ApiImplicitParam(name = "name", value = "供应商名称", paramType = "query", dataType = "String")
	})
	@GetMapping("/getPage")
	public BaseResponse getPage(PageQuery pageQuery, String name) {
		try {
			return supplierService.getPage(pageQuery, name);
		} catch (Exception e) {
			log.debug("供应商分页列表{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "新增供应商")
	@PostMapping("/create")
	public BaseResponse create(@RequestBody SupplierQuery query) {
		try {
			return supplierService.create(query);
		} catch (Exception e) {
			log.debug("新增供应商{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "修改供应商")
	@PostMapping("/update")
	public BaseResponse update(@RequestBody SupplierQuery query) {
		try {
			return supplierService.update(query);
		} catch (Exception e) {
			log.debug("修改供应商{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "供应商详情")
	@GetMapping("/{id}")
	public BaseResponse getById(@PathVariable Integer id) {
		try {
			Supplier supplier = supplierService.getById(id);
			if (supplier == null) {
				return BaseResponse.errorMsg("信息错误!");
			}
			return BaseResponse.okData(supplier);
		} catch (Exception e) {
			log.debug("供应商详情{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "供应商列表")
	@GetMapping("/getList")
	public BaseResponse getList() {
		try {
			List<Supplier> list = supplierService.list();
			return BaseResponse.okData(list);
		} catch (Exception e) {
			log.debug("供应商列表{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "删除供应商")
	@PostMapping("/delete/{id}")
	public BaseResponse delete(@PathVariable Integer id) {
		try {
			supplierService.removeById(id);
			return BaseResponse.okData("删除成功");
		} catch (Exception e) {
			log.debug("删除供应商{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

}

