package cn.wise.sc.cement.business.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;

import java.time.LocalDateTime;
import java.io.Serializable;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 *
 * </p>
 *
 * @author ztw
 * @since 2020-09-02
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class EntityEnclosure implements Serializable {

	private static final long serialVersionUID = 1L;

	/**
	 * 主键
	 */
	@TableId(value = "id", type = IdType.AUTO)
	private Integer id;

	@ApiModelProperty("实体id")
	private Integer entityId;

	/**
	 * 实体类型（0:用户(头像),
	 * 3设备校核附件，4标样材料）
	 */
	@ApiModelProperty("实体类型")
	private Integer entityType;

	@ApiModelProperty("附件地址")
	private String enclosureUrl;

	@ApiModelProperty("创建时间")
	private LocalDateTime createTime;

	@ApiModelProperty("更新时间")
	private LocalDateTime updateTime;

	@ApiModelProperty("是否删除(0:已经删除，1：未删除)")
	private Integer isDeleted;

	@ApiModelProperty("文件名")
	private String alias;

	@ApiModelProperty("扩展名")
	private String extName;

	public interface EntityType {
		int HEAD = 0;
		int EQUIPMENT_TEST = 3;
		int STANDARD_SAMPLE = 4;

	}

}
