package cn.wise.sc.cement.business.entity;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * <p>
 *
 * </p>
 *
 * @author ztw
 * @since 2020-09-01
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Equipment implements Serializable {

	private static final long serialVersionUID = 1L;

	/**
	 * 主键
	 */
	@TableId(value = "id", type = IdType.AUTO)
	private Integer id;

	@ApiModelProperty("设备名称")
	private String name;

	@ApiModelProperty("设备编号")
	private String code;

	@ApiModelProperty("设备品牌")
	private String brand;

	@ApiModelProperty("型号")
	private String model;

	@ApiModelProperty("供应商表id")
	private Integer supplierId;

	@ApiModelProperty("位置")
	private String position;

	@ApiModelProperty("采购日期（购买日期）")
	private LocalDate purchaseDate;

	@ApiModelProperty("资产编码")
	private String assetsCode;

	@ApiModelProperty("资产原值")
	private String assetsValue;

	@ApiModelProperty("状态（0已禁用，1已启用，2故障, 3报废）")
	private Integer status;

	@ApiModelProperty("检/校周期（年）")
	private Integer testCycle;

	@ApiModelProperty("检定日期")
	private LocalDate testDate;

	@ApiModelProperty("校验日期")
	private LocalDate checkDate;

	@ApiModelProperty("期间核查日期")
	private LocalDate periodDate;

	@ApiModelProperty("实施结果")
	private String tryResult;

	@ApiModelProperty("附件地址")
	private String enclosureUrl;

	@ApiModelProperty("文件名")
	private String alias;

	@ApiModelProperty("扩展名")
	private String extName;

	@ApiModelProperty("创建时间")
	private LocalDateTime createTime;

	@ApiModelProperty("备注")
	private String remark;

}
