package cn.wise.sc.cement.business.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.apache.tomcat.jni.Local;

import java.io.Serializable;
import java.time.LocalDate;

/**
 * <p>
 *
 * </p>
 *
 * @author wlb
 * @since 2020-10-19
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName(value = "plan_training")
public class PlanTraining implements Serializable {
	private static final long serialVersionUID = 1L;

	/**
	 * 主键
	 */
	@TableId(value = "id", type = IdType.AUTO)
	private Integer id;

	@ApiModelProperty("培训目的/名称")
	private String objective;

	@ApiModelProperty("培训内容/类别")
	private String content;

	@ApiModelProperty("培训方式")
	private String mode;

	@ApiModelProperty("培训对象")
	private String planObject;

	@ApiModelProperty("培训人")
	private String people;

	@ApiModelProperty("考核人")
	private String assessment;

	@ApiModelProperty("培训地点")
	private String place;

	@ApiModelProperty("考核要求")
	private String requirement;

	@ApiModelProperty("联系电话")
	private String phone;

	@ApiModelProperty("开始时间")
	private LocalDate startTime;

	@ApiModelProperty("结束时间")
	private LocalDate endTime;

	@ApiModelProperty("是否提醒（0：不提醒 1：提醒）")
	private Integer remind;

	@ApiModelProperty("提醒时间")
	private LocalDate remindTime;

	@ApiModelProperty("部门id")
	private String groupIds;

	@ApiModelProperty("用户id")
	private String userIds;

}
