package cn.wise.sc.cement.business.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;

import java.io.Serializable;
import java.util.List;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 *
 * </p>
 *
 * @author ztw
 * @since 2020-08-20
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class SysPermission implements Serializable {

	private static final long serialVersionUID = 1L;

	/**
	 * 主键
	 */
	@TableId(value = "id", type = IdType.AUTO)
	private Integer id;

	@ApiModelProperty("上级ID(如果是一级为0)")
	private Integer parentId;

	@ApiModelProperty("名字")
	private String name;

	@ApiModelProperty("菜单图标")
	private String css;

	@ApiModelProperty("链接")
	private String href;

	@ApiModelProperty("1菜单权限,2按钮权限")
	private Integer type;

	@ApiModelProperty("接口权限")
	private String permission;

	@ApiModelProperty("排序")
	private Integer sort;

	@ApiModelProperty("备注")
	private String remark;

	@ApiModelProperty("子元素")
	@TableField(exist = false)
	private List<SysPermission> child;

}
