package cn.wise.sc.cement.business.model;

import cn.wise.sc.cement.business.model.vo.BaseVo;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 封装公共的接口
 *
 * @param <T> service对象
 * @param <M> 实体对象
 * @author 秦虎
 */
@Slf4j
public class BaseController<T extends IService<M>, M extends BaseEntity> {

	T iService;

	public BaseController(T iService) {
		this.iService = iService;
	}

	@PostMapping("/list")
	public BaseResponse<List<M>> list(@RequestBody WrapperQuery wrapperQuery) {
		QueryWrapper queryWrapper = PageWrapperQueryMyBatisResolver.getQueryWrapper(wrapperQuery);
		try {
			List<M> list = iService.list(queryWrapper);
			return BaseResponse.okData(list);
		} catch (Exception ex) {
			log.error("查询操作失败 ===== " + iService.toString() + ".list()  ======  异常: {}", ex.getMessage());
			return BaseResponse.errorMsg("查询失败");
		}
	}

	@PostMapping("/page")
	public BaseResponse<IPage<M>> page(@RequestBody WrapperQuery pageQuery) {

		QueryWrapper queryWrapper = PageWrapperQueryMyBatisResolver.getQueryWrapper(pageQuery);
		IPage<M> page = new Page(pageQuery.getPageQuery().getPageNo(), pageQuery.getPageQuery().getPageSize());
		try {
			page = iService.page(page, queryWrapper);
			return BaseResponse.okData(page);
		} catch (Exception ex) {
			log.error("查询操作失败 ===== " + iService.toString() + ".page()  ======  异常: {}", ex.getMessage());
			return BaseResponse.errorMsg("分页查询失败");
		}
	}

	@GetMapping("/{id}")
	public BaseResponse<BaseVo> getById(@PathVariable("id") long id) {
		try {
			M model = iService.getById(id);
			return BaseResponse.okData(model.toVo());
		} catch (Exception ex) {
			log.error("查询操作失败 ===== " + iService.toString() + ".create()  ======  异常: {}", ex.getMessage());
			return BaseResponse.errorMsg("获取详情信息失败");
		}
	}

	@PostMapping
	public BaseResponse<BaseVo> create(@RequestBody M model) {
		try {
			iService.save(model);
			return BaseResponse.okData(model.toVo());
		} catch (Exception ex) {
			log.error("查询操作失败 ===== " + iService.toString() + ".create()  ======  异常: {}", ex.getMessage());
			return BaseResponse.errorMsg("添加失败");
		}
	}

	@PutMapping
	public BaseResponse<Boolean> update(@RequestBody M model) {
		try {
			boolean update = iService.updateById(model);
			return BaseResponse.okData(update);
		} catch (Exception ex) {
			log.error("查询操作失败 ===== " + iService.toString() + ".create()  ======  异常: {}", ex.getMessage());
			return BaseResponse.errorMsg("更新记录失败");
		}
	}

	@DeleteMapping("/{id}")
	public BaseResponse<Boolean> delById(@PathVariable("id") long id) {
		try {
			boolean removeById = iService.removeById(id);
			return BaseResponse.okData(removeById);
		} catch (Exception ex) {
			log.error("查询操作失败 ===== " + iService.toString() + ".create()  ======  异常: {}", ex.getMessage());
			return BaseResponse.errorMsg("获取详情信息失败");
		}
	}

}
