package cn.wise.sc.cement.business.model.query;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.NonNull;
import lombok.RequiredArgsConstructor;

import javax.validation.constraints.NotEmpty;
import java.time.LocalDate;

/**
 * @description: 能力管理信息
 * @author: wlb
 * @create: 2020-09-17
 **/
@Data
@RequiredArgsConstructor
@NoArgsConstructor
@ApiModel("能力管理信息")
public class CapabilityManagementQuery {
	private Integer id;

	@ApiModelProperty(name = "capabilityItem", value = "能力项")
	@NotEmpty(message = "能力项不能为空!")
	@NonNull
	private String capabilityItem;

	@ApiModelProperty(name = "capabilityRange", value = "能力范围")
	@NotEmpty(message = "能力范围不能为空!")
	@NonNull
	private String capabilityRange;

	@ApiModelProperty(name = "obtainTime", value = "取得日期")
	private LocalDate obtainTime;

	@ApiModelProperty(name = "remark", value = "备注")
	private String remark;

	private Integer userId;
}
