package cn.wise.sc.cement.business.model.query;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * @description:
 * @author: ztw
 * @create: 2020-08-07 14:58
 **/
@Data
@ApiModel("设备请求")
public class EquipmentQuery {

	private Integer id;

	@ApiModelProperty("设备名称")
	private String name;

	@ApiModelProperty("设备编号")
	private String code;

	@ApiModelProperty("设备品牌")
	private String brand;

	@ApiModelProperty("型号")
	private String model;

	@ApiModelProperty("供应商表id")
	private Integer supplierId;

	@ApiModelProperty("位置")
	private String position;

	@ApiModelProperty("采购日期（购买日期）")
	@DateTimeFormat(pattern = "yyyy-MM-dd")
	@JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
	private LocalDate purchaseDate;

	@ApiModelProperty("资产编码")
	private String assetsCode;

	@ApiModelProperty("资产原值")
	private String assetsValue;

	@ApiModelProperty("检/校周期（年）")
	private Integer testCycle;

	@ApiModelProperty("备注")
	private String remark;

}
