package cn.wise.sc.cement.business.model.query;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @description:
 * @author: ztw
 * @create: 2020-08-07 14:58
 **/
@Data
@ApiModel("标样请求")
public class StandardQuery {

	private Integer id;

	@ApiModelProperty("标准样品名称")
	private String name;

	@ApiModelProperty("标准样品代号")
	private String code;

	@ApiModelProperty("供应商表id")
	private Integer supplierId;

	@ApiModelProperty("购买厂商（经销单位）")
	private String supplierName;

	@ApiModelProperty("进样日期")
	private LocalDate purchaseDate;

	@ApiModelProperty("有效日期")
	private LocalDate validDate;

	@ApiModelProperty("存储位置")
	private String position;

	@ApiModelProperty("库存数量")
	private BigDecimal stockNum;

	@ApiModelProperty("库存提醒数量（少于多少进行提醒）")
	private BigDecimal leastNum;

	@ApiModelProperty("备注")
	private String remark;

	private String enclosure;

	@ApiModelProperty("标样材料信息")
	private List<EnclosureQuery> enclosureQueryList;

	@ApiModelProperty("标准值")
	private List<StandardValueQuery> standardValueQueryList;

}
