package cn.wise.sc.cement.business.model.query;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.RequiredArgsConstructor;

import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * @description: 用户请求
 * @author: qh
 * @create: 2020-08-07 14:58
 **/
@Data
@ApiModel("用户请求")
public class UserQuery {

	private Integer id;

	@ApiModelProperty("用户账号")
	private String username;

	@ApiModelProperty("真实姓名")
	private String name;

	@ApiModelProperty("性别0女1男")
	private Integer sex;

	@ApiModelProperty("部门id")
	private Integer groupId;

	@ApiModelProperty("职务id")
	private Integer postId;

	@ApiModelProperty("微信号")
	private String wxId;

	@ApiModelProperty("职称")
	private String qualifications;

	@ApiModelProperty("工作年限")
	private Double workYear;

	@ApiModelProperty("手机号")
	private String phone;

	@ApiModelProperty("传真")
	private String fax;

	@ApiModelProperty("专业")
	private String major;

	@ApiModelProperty("邮箱")
	private String email;

	@ApiModelProperty("从事本技术领域日期")
	private LocalDate technologyDate;

	@ApiModelProperty("从事本技术领域年限")
	private Double technologyYear;

	@ApiModelProperty("文化程度")
	private String education;

	@ApiModelProperty("备注")
	private String remark;

	@ApiModelProperty("角色id")
	private Integer roleId;

}
