package cn.wise.sc.cement.business.model.vo;

import cn.wise.sc.cement.business.model.query.SampleTmpQuery;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @description:
 * @author: ztw
 * @create: 2020-08-07 14:58
 **/
@Data
@ApiModel("委托Vo")
public class EntrustVo {
	@ApiModelProperty("委托表id")
	private Integer id;

	@ApiModelProperty("委托编号")
	private String entrustCode;

	@ApiModelProperty("项目id")
	private Integer projectId;

	@ApiModelProperty("项目名称")
	private String projectName;

	@ApiModelProperty("项目编号")
	private String projectCode;

	@ApiModelProperty("项目类型(常规项目，科研项目，质量控制项目)")
	private String projectType;

	@ApiModelProperty("是否发送样品处理（1是，0否）")
	private Integer isHandle;

	@ApiModelProperty("是否派发样品检测（1是，0否）")
	private Integer isDistribution;

	@ApiModelProperty("委托人id")
	private Integer userId;

	@ApiModelProperty("委托人姓名")
	private String userName;

	@ApiModelProperty("委托人手机号码")
	private String userPhone;

	@ApiModelProperty("委托人传真")
	private String userFax;

	@ApiModelProperty("委托单位Id")
	private Integer clientId;

	@ApiModelProperty("委托单位姓名")
	private String clientName;

	@ApiModelProperty("委托日期")
	private LocalDate entrustDate;

	@ApiModelProperty("样品数量")
	private Integer sampleNum;

	@ApiModelProperty("状态（0未评审，1已通过，2未通过，3样品处理中，4样品处理完成，" +
			"5样品检测中，6样品检测完成，7校核中，8校核完成）")
	private Integer status;

	@ApiModelProperty("状态")
	private String statusValue;

	@ApiModelProperty("送样人姓名")
	private String sendName;

	@ApiModelProperty("送样人电话")
	private String sendPhone;

	@ApiModelProperty("拟定完成日期")
	private LocalDate finishDate;

	@ApiModelProperty("（1加急，0不加急）")
	private Integer isUrgent;

	@ApiModelProperty(" 剩余样品处理方法（0,取回，1由本所统一处置）")
	private Integer handleMethod;

	@ApiModelProperty("创建时间")
	private LocalDateTime createTime;

	@ApiModelProperty("修改时间")
	private LocalDateTime updateTime;

	@ApiModelProperty("备注")
	private String remark;

	/**
	 * 样品及检测项
	 */
	@ApiModelProperty("样品临时列表 新建的时候展示")
	private List<SampleTmpVo> sampleTmpList;

	@ApiModelProperty("样品列表（展示平行样的样品）派发的时候展示")
	private List<SampleVo> sampleList;

	@ApiModelProperty("样品处理列表（不展示平行样的样品）样品处理的时候展示")
	private List<SampleVo> sampleHandleList;

	@ApiModelProperty("检测项 只显示第一个样品的")
	private String checkTeam;

	@ApiModelProperty("所有样品名称")
	private String sampleNames;

	@ApiModelProperty("所有处理项名称")
	private String handleNames;

	@ApiModelProperty("检测依据编号 只显示第一个样品的")
	private String checkMethodNumber;

	@ApiModelProperty("任务接受时间")
	private LocalDateTime acceptTime;

	@ApiModelProperty("评审意见")
	private String opinion;

}
