package cn.wise.sc.cement.business.model.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * @description:
 * @author: ztw
 * @create: 2020-08-07 15:09
 **/

@Data
@ApiModel("设备维护计划Vo")
public class PlanEquipmentMaintainVo {

	@ApiModelProperty("设备维护计划表id")
	private Integer id;

	@ApiModelProperty("产品名称")
	private String name;

	@ApiModelProperty("规格型号")
	private String model;

	@ApiModelProperty("编号")
	private String code;

	@ApiModelProperty("维护日期")
	private LocalDate maintainDate;

	@ApiModelProperty("创建人id")
	private Integer userId;

	@ApiModelProperty("创建人姓名")
	private String userName;

	@ApiModelProperty("设备维护人id")
	private Integer maintainerId;

	@ApiModelProperty("设备维护人姓名")
	private String maintainerName;

	@ApiModelProperty("维护内容")
	private String maintainContent;

	@ApiModelProperty("维护结果")
	private String maintainResult;

	@ApiModelProperty("设备维护计划附件地址")
	private String enclosureUrl;

	@ApiModelProperty("附件名")
	private String alias;

	@ApiModelProperty("附件扩展名")
	private String extName;

	@ApiModelProperty("状态（0待完成，1已完成）")
	private Integer status;

	@ApiModelProperty("创建时间")
	private LocalDateTime createTime;

	@ApiModelProperty("备注")
	private String remark;

}
