package cn.wise.sc.cement.business.service;

import cn.wise.sc.cement.business.entity.Method;
import cn.wise.sc.cement.business.model.BaseResponse;
import cn.wise.sc.cement.business.model.PageQuery;
import cn.wise.sc.cement.business.model.query.MethodQuery;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * <p>
 * 服务类
 * </p>
 *
 * @author ztw
 * @since 2020-08-18
 */
public interface IMethodService extends IService<Method> {

	/**
	 * 获取分页
	 *
	 * @param pageQuery
	 * @param name
	 * @param standard
	 * @return
	 */
	BaseResponse<IPage<Method>> getPage(PageQuery pageQuery, String name, String standard);

	/**
	 * 获取所有信息
	 *
	 * @return
	 */
	BaseResponse<List<Method>> getList();

	/**
	 * 新增
	 *
	 * @param query
	 * @return
	 */
	BaseResponse<Method> create(MethodQuery query);

	/**
	 * 编辑
	 *
	 * @param query
	 * @return
	 */
	BaseResponse<Method> update(MethodQuery query);

	/**
	 * 导出
	 *
	 * @param name
	 * @param standard
	 * @param fileName
	 * @param response
	 */
	void export(String name, String standard, String fileName, HttpServletResponse response);

	/**
	 * 删除检测方法
	 *
	 * @param id
	 * @return
	 */
	BaseResponse delete(Integer id);

}
